<?php $__env->startSection('title','لیست پلن های نمایندگان'); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">لیست پلن های نمایندگان</h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('admin.dashboard.sellers.plans.list')); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">لیست پلن های نمایندگان</h3>
                    <div class="card-tools">
                        <a href="#addPlan" class="btn btn-success" onclick="addPlanModal()">+</a>
                    </div>
                </div>
                <div class="card-body">
                    <table id="sellersTable" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>عنوان</th>
                            <th>موجودی بیشتر به ازای هر افزایش موجودی</th>
                            <th>تخفیف بیشتر خرید پلان</th>
                            <th>حداقل واریز ۳ماهه</th>
                            <th>درصد سود از زیر مجموعه</th>
                            <th>حداکثر تعداد زیر مجموعه</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($plan->title); ?></td>
                                <td><?php echo e($plan->deposit_bonus); ?> ٪</td>
                                <td><?php echo e($plan->discount_plan); ?> ٪</td>
                                <td><?php echo e(number_format($plan->min_three_months_deposit)); ?> تومان</td>
                                <td><?php echo e($plan->referral_percent); ?> ٪ از شارژ زیر مجموعه</td>
                                <td><?php echo e($plan->max_referral_count); ?></td>
                                <td>
                                    <a class="btn btn-outline-secondary btn-sm" href="#" onclick="editPlanModal('editPlan-<?php echo e($plan->id); ?>')">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('admin.dashboard.sellers.plans.remove',$plan->id)); ?>">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                </td>
                            </tr>
                            <div id="editPlan-<?php echo e($plan->id); ?>" class="modal">
                                <form method="post" action="<?php echo e(route('admin.dashboard.sellers.plans.edit',$plan->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-lg-12 form-group text-right">
                                            <label>عنوان</label>
                                            <input type="text" name="title" class="form-control" value="<?php echo e($plan->title); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>موجودی بیشتر به ازای هر افزایش موجودی</label>
                                            <input type="tel" name="deposit_bonus" class="form-control" value="<?php echo e($plan->deposit_bonus); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>تخفیف بیشتر خرید پلان</label>
                                            <input type="tel" name="discount_plan" class="form-control" value="<?php echo e($plan->discount_plan); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>حداقل واریز ۳ماهه</label>
                                            <input type="tel" name="min_three_months_deposit" class="form-control" value="<?php echo e($plan->min_three_months_deposit); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>درصد سود از زیر مجموعه</label>
                                            <input type="tel" name="referral_percent" class="form-control" value="<?php echo e($plan->referral_percent); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>حداکثر تعداد زیر مجموعه</label>
                                            <input type="tel" name="max_referral_count" class="form-control" value="<?php echo e($plan->max_referral_count); ?>">
                                        </div>

                                        <div class="col-lg-12 form-group">
                                            <button type="submit" class="btn btn-success">ثبت</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>عنوان</th>
                            <th>موجودی بیشتر به ازای هر افزایش موجودی</th>
                            <th>تخفیف بیشتر خرید پلان</th>
                            <th>حداقل واریز ۳ماهه</th>
                            <th>درصد سود از زیر مجموعه</th>
                            <th>حداکثر تعداد زیر مجموعه</th>
                            <th>عملیات</th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
    <div id="addPlan" class="modal">
        <form method="post" action="<?php echo e(route('admin.dashboard.sellers.plans.add')); ?>">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>عنوان</label>
                    <input type="text" name="title" class="form-control" placeholder="عنوان">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>موجودی بیشتر به ازای هر افزایش موجودی</label>
                    <input type="tel" name="deposit_bonus" class="form-control" value="0">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>تخفیف بیشتر خرید پلان</label>
                    <input type="tel" name="discount_plan" class="form-control" value="0">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>حداقل واریز ۳ماهه</label>
                    <input type="tel" name="min_three_months_deposit" class="form-control" value="0">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>درصد سود از زیر مجموعه</label>
                    <input type="tel" name="referral_percent" class="form-control" value="0">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>حداکثر تعداد زیر مجموعه</label>
                    <input type="tel" name="max_referral_count" class="form-control" value="0">
                </div>

                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script>
        $("#sellersTable").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script>
        function addPlanModal(){
            $('#addPlan').modal({
                showClose: false,
            });
        }
        function editPlanModal(id){
            $('#'+id).modal({
                showClose: false,
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/muzillagate/public_html/Wire/resources/views/admin/dashboard/seller/plan/list.blade.php ENDPATH**/ ?>