<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e(asset('/assets/images/favicon.png')."?v=".env('APP_VERSION')); ?>" type="image/png">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/dist/css/adminlte.css')."?v=".env('APP_VERSION')); ?>">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

    <!-- bootstrap rtl -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/dist/css/bootstrap-rtl.min.css')."?v=".env('APP_VERSION')); ?>">
    <!-- template rtl version -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/dist/css/custom-style.css')."?v=".env('APP_VERSION')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/dist/css/wg-style.css')."?v=".env('APP_VERSION')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset("assets/plugins/toastr/toastr.min.css")."?v=".env('APP_VERSION')); ?>">
    <script src="<?php echo e(asset('assets/plugins/tippy/popper.min.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/tippy/tippy-bundle.umd.min.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/intro/intro.js')."?v=".env('APP_VERSION')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset("assets/plugins/intro/introjs.css")."?v=".env('APP_VERSION')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset("assets/plugins/intro/introjs-rtl.css")."?v=".env('APP_VERSION')); ?>">

    <?php echo $__env->yieldContent('end_head'); ?>
    <?php echo $__env->make('googletagmanager::head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body class="hold-transition sidebar-mini layout-fixed wgt">
<?php echo $__env->make('googletagmanager::body', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <!-- Left navbar links -->
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#"><i class="fa fa-bars"></i></a>
            </li>
        </ul>
    </nav>
    <!-- /.navbar -->
    <!-- Main Sidebar Container -->
    <?php echo $__env->make('seller.dashboard.main.left-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <?php echo $__env->yieldContent('content-header'); ?>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <footer class="main-footer d-flex justify-content-between">
        <p style="margin-bottom: 0 !important;">قدرت گرفته با <a style="color: red">♡</a> توسط تیم موزیلاگیت</p>
        <p class="mr-auto wgt-enNumber" style="margin-bottom: 0 !important;">v.<?php echo e(env('APP_VERSION')); ?></p>
    </footer>

    <!-- Control Sidebar -->



    <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="<?php echo e(asset('assets/plugins/jquery/jquery.min.js')."?v=".env('APP_VERSION')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js')."?v=".env('APP_VERSION')); ?>"></script>
<!-- FastClick -->
<script src="<?php echo e(asset('assets/plugins/fastclick/fastclick.js')."?v=".env('APP_VERSION')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset('assets/dist/js/adminlte.min.js')."?v=".env('APP_VERSION')); ?>"></script>
<!-- AdminLTE for demo purposes -->
<script src="<?php echo e(asset('assets/dist/js/demo.js')."?v=".env('APP_VERSION')); ?>"></script>

<script src="<?php echo e(asset('assets/dist/js/demo.js')."?v=".env('APP_VERSION')); ?>"></script>
<!--  Toastr  -->
<script src="<?php echo e(asset("assets/plugins/toastr/toastr.min.js")."?v=".env('APP_VERSION')); ?>"></script>
<?php if(session('toastr_success')): ?>
    <script>
        toastr.success('<?php echo e(session('toastr_success')); ?>');
    </script>
<?php endif; ?>
<?php if(session('toastr_info')): ?>
    <script>
        toastr.info('<?php echo e(session('toastr_info')); ?>');
    </script>
<?php endif; ?>
<?php if(session('toastr_warning')): ?>
    <script>
        toastr.warning('<?php echo e(session('toastr_warning')); ?>');
    </script>
<?php endif; ?>
<?php if(session('toastr_error')): ?>
    <script>
        toastr.error('<?php echo e(session('toastr_error')); ?>');
    </script>
<?php endif; ?>
<script>
    function enableLoadingBtn(btn){
        btn.disabled = true
    }
    function disableLoadingBtn(btn){
        btn.disabled = false
    }
    function submitForm(form){
        return $.ajax({
            url: form.action,
            type: form.method,
            data: new FormData(form),
            processData: false,
            contentType: false,
        });
    }
</script>
<?php echo $__env->yieldContent('end_body'); ?>
</body>
</html>
<?php /**PATH /home/muzillagate/public_html/Wire/resources/views/seller/dashboard/main/main.blade.php ENDPATH**/ ?>