<?php $__env->startSection('title','کاربران'); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">کاربران</h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('seller.dashboard.users.index')); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">کاربران</h3>
                </div>
                <div class="card-body">
                    <table id="usersTable" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>نام کاربری</th>
                            <th>ایمیل</th>
                            <th>تلفن</th>
                            <th>تعداد کانکشن</th>
                            <th>تاریخ ایجاد</th>
                            <th>زمان آخرین فعالیت</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>

                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($user->username); ?></td>
                                <td><?php echo e($user->email??"نامشخص"); ?></td>
                                <td><?php echo e($user->phone??"نامشخص"); ?></td>
                                <td><?php echo e(count($user->peers)); ?> عدد</td>
                                <td><?php echo e(jdate($user->created_at)); ?></td>
                                <td><?php echo e(($user->last_activity()??0)?jdate($user->last_activity()):"--"); ?></td>
                                <td>
                                    <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('seller.dashboard.users.show',$user->id)); ?>">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a class="btn btn-sm" onclick="editUserModal('<?php echo e($user->id); ?>')" href="#editUser">
                                        <i class="fa fa-edit text-secondary"></i>
                                    </a>
                                </td>
                            </tr>
                            <div id="editUser-<?php echo e($user->id); ?>" class="modal">
                                <form method="post" action="<?php echo e(route('seller.dashboard.users.editUser',$user->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-lg-12 form-group">
                                            <input type="text" name="username" class="form-control" placeholder="نام کاربری" value="<?php echo e($user->username); ?>" required>
                                        </div>
                                        <div class="col-lg-12 form-group">
                                            <input type="text" name="email" class="form-control" placeholder="ایمیل" value="<?php echo e($user->email); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group">
                                            <input type="text" name="phone" class="form-control" placeholder="تلفن" value="<?php echo e($user->phone); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group">
                                            <button type="submit" class="btn btn-success">ثبت</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>نام کاربری</th>
                            <th>ایمیل</th>
                            <th>تلفن</th>
                            <th>تعداد کانکشن</th>
                            <th>تاریخ ایجاد</th>
                            <th>زمان آخرین فعالیت</th>
                            <th>عملیات</th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">افزودن کاربر</h3>
                </div>
                <form action="<?php echo e(route('seller.dashboard.users.addUser')); ?>"  method="post">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4 form-group">
                                <input type="text" name="username" class="form-control" placeholder="نام کاربری" required>
                            </div>
                            <div class="col-lg-4 form-group">
                                <input type="text" name="email" class="form-control" placeholder="ایمیل">
                            </div>
                            <div class="col-lg-4 form-group">
                                <input type="text" name="phone" class="form-control" placeholder="تلفن">
                            </div>

                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-success">ثبت</button>
                    </div>
                </form>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script>
        $("#usersTable").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script>
        function editUserModal(userId){
            $('#editUser-'+userId).modal({
                showClose: false,
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('seller.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/muzillagate/public_html/Wire/resources/views/seller/dashboard/users/index.blade.php ENDPATH**/ ?>