<?php $__env->startSection('title','تاریخچه کیف پول'); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">تاریخچه کیف پول</h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('seller.dashboard.financial.walletHistory')); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تاریخچه کیف پول</h3>
                </div>
                <div class="card-body">
                    <table id="walletHistory" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>تاریخ</th>
                            <th>نوع</th>
                            <th>مبلغ</th>
                            <th>توضیح</th>
                        </tr>
                        </thead>
                        <tbody>

                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="number-item">
                                <td class="number-item__date">
                                    <time datetime="<?php echo e((jdate($transaction->updated_at))); ?>"><?php echo e((jdate($transaction->updated_at))); ?></time>
                                </td>
                                <td class="number-item__type">
                                    <span class="number-item__type--success"><?php echo e(__($transaction->type)); ?></span>
                                </td>
                                <td class="number-item__price"><?php echo e((number_format($transaction->amount))); ?> تومان</td>
                                <td class="number-item__gateway"><?php echo e($transaction->meta['description']??""); ?></td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script>
        $("#walletHistory").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('seller.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/muzillagate/public_html/Wire/resources/views/seller/dashboard/financial/walletHistory.blade.php ENDPATH**/ ?>