<?php $__env->startSection('title',$user->username); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"><?php echo e($user->username); ?></h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('seller.dashboard.users.show',$user)); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-cyan">
                <div class="card-body">
                    <div class="table-wrapper">
                        <table class="table table-striped">
                            <tr>
                                <td>نام کاربری</td>
                                <td><?php echo e($user->username); ?></td>
                            </tr>
                            <tr>
                                <td>تلفن</td>
                                <td><?php echo e($user->phone??"نامشخص"); ?></td>
                            </tr>
                            <tr>
                                <td>ایمیل</td>
                                <td><?php echo e($user->email??"نامشخص"); ?></td>
                            </tr>
                            <tr>
                                <td>تعداد کانکشن ها</td>
                                <td><?php echo e($user->peers->count()); ?></td>
                            </tr>
                            <tr>
                                <td>وضعیت</td>
                                <td>
                                    <?php if($user->status == App\Status\User::ACTIVE): ?>
                                        <span class="badge badge-success">فعال</span>
                                    <?php elseif($user->status == App\Status\User::INACTIVE): ?>
                                        <span class="badge badge-danger">غیر فعال</span>
                                    <?php else: ?>
                                        <span class="badge badge-warning">نامشخص</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <?php
            function destroyString($string){
                if (strlen($string) > 6) {
                    $start = substr($string, 0, 7); // extract the first 5 characters
                    $end = substr($string, -7); // extract the last 8 characters

                    $middle = '...'; // placeholder for the middle portion
                    $result = $start . $middle . $end;
                } else {
                    $result = $string; // if the string is already shorter than the maximum length
                }
                return $result;
            }
            ?>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">کانکشن ها</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('seller.dashboard.users.addPeer',$user->id)); ?>" class="btn btn-success" style="border-color: #fff;">خرید</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-wrapper">
                        <table id="peerHistory" class="table table-bordered table-hover display" style="width:100%">
                            <thead>
                            <tr>
                                <th>شناسه</th>
                                <th>توضیح</th>
                                <th>شناسه عمومی</th>
                                <th>کشور</th>
                                <th>حجم کل</th>
                                <th>حجم مصرفی</th>
                                <th>زمان پایان</th>
                                <th>قابلیت تمدید</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php $__currentLoopData = $user->peers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $peer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="peer-item">
                                    <td class="peer-item__title">
                                        <?php echo e($peer->id); ?>

                                    </td>
                                    <td class="peer-item__title">
                                        <?php echo e($peer->description??"نامشخص"); ?>

                                    </td>
                                    <td class="peer-item__title " style="direction: ltr">
                                        <?php echo e(destroyString($peer->publicKey())); ?>

                                    </td>
                                    <td class="peer-item__country">
                                        <?php echo e($peer->wireguard->location); ?>

                                    </td>
                                    <td class="peer-item__traffic_restrictions">
                                        <?php echo e($peer->traffic_restrictions/1000); ?> GB
                                    </td>
                                    <td class="peer-item__traffic_usage_total">
                                        <?php echo e($peer->traffic_usage_current() + $peer->traffic_usage_total()); ?> GB
                                    </td>
                                    <td class="peer-item__expired_at">
                                        <?php echo e(jdate($peer->expires_at)); ?>

                                    </td>
                                    <td class="peer-item__extension">
                                        <?php echo e($peer->canExtension()?"✅":"❌"); ?>

                                    </td>
                                    <td class="peer-item__status">
                                        <?php if($peer->status == App\Status\Peer::ACTIVE): ?>
                                            <span class="badge badge-success">فعال</span>
                                            <a class="btn btn-outline-success btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.togglePeerStatus',$peer->id)); ?>">
                                                <i class="fa fa-toggle-on"></i>
                                            </a>
                                        <?php elseif($peer->status == App\Status\Peer::INACTIVE): ?>
                                            <span class="badge badge-danger">غیر فعال</span>
                                            <a class="btn btn-outline-danger btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.togglePeerStatus',$peer->id)); ?>">
                                                <i class="fa fa-toggle-off"></i>
                                            </a>
                                        <?php elseif($peer->status == App\Status\Peer::EXPIRED): ?>
                                            <span class="badge badge-warning">منقضی</span>
                                        <?php else: ?>
                                            <span class="badge badge-warning">نامشخص</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="peer-item__status">
                                        <?php if($peer->status == App\Status\Peer::ACTIVE): ?>
                                            <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.getConfig',$peer->id)); ?>">
                                                <i class="fa fa-download"></i>
                                            </a>
                                            <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.getConfigQR',$peer->id)); ?>">
                                                <i class="fa fa-qrcode"></i>
                                            </a>
                                        <?php endif; ?>
                                        <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.show',$peer->id)); ?>">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">تاریخچه فعالیت کاربر</h3>
                    </div>
                    <div class="card-body">
                        <table id="userLogs" class="table table-bordered table-hover display" style="width:100%">
                            <thead>
                            <tr>
                                <th>تاریخ</th>
                                <th>توضیح</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php $__currentLoopData = $user->logs->sortByDesc('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="peerLog-item">
                                    <td class="peerLog-item__date">
                                        <time datetime="<?php echo e((jdate($log->created_at))); ?>"><?php echo e((jdate($log->created_at))); ?></time>
                                    </td>
                                    <td class="peerLog-item__log"><?php echo e((new \App\Helper\Translate())->string($log->log)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script>
        $("#peerHistory").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
        $("#userLogs").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('seller.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/muzillagate/public_html/Wire/resources/views/seller/dashboard/users/show.blade.php ENDPATH**/ ?>