<?php $__env->startSection('title',$server->title); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"><?php echo e($server->title??"نامشخص"); ?></h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('admin.dashboard.servers.show',$server)); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-cyan">
                <div class="card-body">
                    <div class="table-wrapper">
                        <table class="table table-striped">
                            <tr>
                                <td>نام کاربری</td>
                                <td class="wgt-enNumber"><?php echo e($server->username); ?></td>
                            </tr>
                            <tr>
                                <td>آیپی</td>
                                <td class="wgt-enNumber"><?php echo e($server->ipAddress??"نامشخص"); ?></td>
                            </tr>
                            <tr>
                                <td>نام کاربری</td>
                                <td class="wgt-enNumber"><?php echo e($server->username??"نامشخص"); ?></td>
                            </tr>
                            <tr>
                                <td>کلمه عبور</td>
                                <td class="wgt-enNumber"><?php echo e($server->password); ?></td>
                            </tr>
                            <tr>
                                <td>پورت ورود</td>
                                <td class="wgt-enNumber"><?php echo e($server->apiPort); ?></td>
                            </tr>

                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-warning" onclick="editServerModal()">ویرایش</button>
                </div>
            </div>

            <div class="card card-cyan">
                <div class="card-header">
                    <h3 class="card-title">اینترفیس های وایرگارد</h3>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $server->wireguards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wireguard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="text-center">
                            <p class="font-weight-bold" style="font-size: 25px"><?php echo e($wireguard->title); ?>

                                <a class="btn btn-sm" href="#" onclick="editWireguardModal('editInterface_<?php echo e($wireguard->id); ?>')">
                                    <i class="fa fa-edit text-secondary"></i>
                                </a>
                            </p>
                        </div>
                        <div class="table-wrapper">
                            <table class="table table-striped">
                                <tr>
                                    <td>نام اینترفیس</td>
                                    <td class="wgt-enNumber"><?php echo e($wireguard->interfaceName); ?></td>
                                </tr>
                                <tr style="direction: ltr;">
                                    <td>کلید عمومی</td>
                                    <td class="wgt-enNumber"><?php echo e((new \App\Helper\WireGuardHelper())->privateKeyToPublicKey($wireguard->privateKey)); ?></td>
                                </tr>
                                <tr>
                                    <td>پورت</td>
                                    <td class="wgt-enNumber"><?php echo e($wireguard->listenPort); ?></td>
                                </tr>
                                <tr>
                                    <td>DNS</td>
                                    <td class="wgt-enNumber"><?php echo e($wireguard->dns); ?></td>
                                </tr>
                                <tr>
                                    <td>موقعیت</td>
                                    <td class="wgt-enNumber"><?php echo e($wireguard->location); ?></td>
                                </tr>
                                <tr>
                                    <td>دامین</td>
                                    <td class="wgt-enNumber"><?php echo e($wireguard->domain); ?></td>
                                </tr>
                            </table>
                        </div>
                        <div id="editInterface_<?php echo e($wireguard->id); ?>" class="modal">
                            <form method="post" action="<?php echo e(route('admin.dashboard.servers.editWireguard',['server_id'=>$server->id,'wireguard_id'=>$wireguard->id])); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-lg-12 form-group text-right">
                                        <label>عنوان</label>
                                        <input type="text" name="title" class="form-control" value="<?php echo e($wireguard->title); ?>">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>نام اینترفیس</label>
                                        <input type="text" name="interfaceName" class="form-control" value="<?php echo e($wireguard->interfaceName); ?>">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>پورت</label>
                                        <input type="tel" name="listenPort" class="form-control" value="<?php echo e($wireguard->listenPort); ?>">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>DNS</label>
                                        <input type="text" name="dns" class="form-control" value="<?php echo e($wireguard->dns); ?>">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>موقعیت</label>
                                        <input type="text" name="location" class="form-control" value="<?php echo e($wireguard->location); ?>">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>دامین</label>
                                        <input type="text" name="domain" class="form-control" value="<?php echo e($wireguard->domain); ?>">
                                    </div>
                                    <div class="col-lg-12 form-group">
                                        <button type="submit" class="btn btn-success">ثبت</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <div id="editServer" class="modal">
        <form method="post" action="<?php echo e(route('admin.dashboard.servers.edit',$server->id)); ?>">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>عنوان</label>
                    <input type="text" name="title" class="form-control" value="<?php echo e($server->title); ?>">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>ایپی</label>
                    <input type="text" name="ipAddress" class="form-control" value="<?php echo e($server->ipAddress); ?>">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>نام کاربری</label>
                    <input type="text" name="username" class="form-control" value="<?php echo e($server->username); ?>">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>کلمه عبور</label>
                    <input type="text" name="password" class="form-control" value="<?php echo e($server->password); ?>">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>پورت ورود</label>
                    <input type="text" name="apiPort" class="form-control" value="<?php echo e($server->apiPort); ?>">
                </div>
                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script>
        function editServerModal(){
            $('#editServer').modal({
                showClose: false,
            });
        }
        function editWireguardModal(id){
            $('#'+id).modal({
                showClose: false,
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/muzillagate/public_html/Wire/resources/views/admin/dashboard/server/show.blade.php ENDPATH**/ ?>