<?php $__env->startSection('title',$peer->user->username.' - '.($peer->description??'نامشخص')); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"><?php echo e($peer->description??'نامشخص'); ?></h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('seller.dashboard.users.peer.showPeer',$peer)); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-cyan">
                <div class="card-body">
                    <div class="table-wrapper">
                        <table class="table table-striped">
                            <tr>
                                <td>شناسه کانکشن</td>
                                <td><?php echo e($peer->id); ?></td>
                            </tr>
                            <td>شناسه یکتا</td>
                            <td>
                                <?php if(!$peer->unique_id): ?>
                                    <a class="btn btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.refreshUniqueId',$peer->id)); ?>">ایجاد شناسه یکتا</a>
                                <?php else: ?>
                                    <div style="display: ruby">
                                        <div type="text" class="form-control" style="text-align: center; background: #ececec;width: fit-content;" onclick="selectTextInDivAndCopy(this);"><?php echo e($peer->unique_id); ?></div>
                                        <a class="btn btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.refreshUniqueId',$peer->id)); ?>">تغییر شناسه یکتا</a>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <tr>
                                <td>کشور</td>
                                <td><?php echo e($peer->wireguard->location); ?></td>
                            </tr>
                            <tr>
                                <td>حجم کل</td>
                                <td><?php echo e($peer->traffic_restrictions/1000); ?> GB
                                    <?php if(count($peer->user->active_peers())>=2): ?>
                                        <a class="btn  btn-sm" href="#trafficTransfer" onclick="trafficTransferModal()">
                                            <i class="fa fa-plus text-secondary"></i>
                                        </a>
                                    <?php endif; ?>
                                </td>

                            </tr>
                            <tr>
                                <td>حجم مصرفی</td>
                                <td><?php echo e($peer->traffic_usage_current() + $peer->traffic_usage_total()); ?> GB</td>
                            </tr>
                            <tr>
                                <td>زمان پایان</td>
                                <td><?php echo e(jdate($peer->expires_at)); ?></td>
                            </tr>
                            <tr>
                                <td>توضیحات</td>
                                <td><?php echo e($peer->description??'نامشخص'); ?>

                                    <a class="btn btn-sm" href="#editDescription" onclick="editDescriptionModal()">
                                        <i class="fa fa-edit text-secondary"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>وضعیت تمدید</td>
                                <td><?php echo e($peer->extension_plan->title??"تمدید نشده"); ?></td>
                            </tr>
                            <?php if((($peer->auto_extension) || ($peer->peer_plan_id!=null))): ?>
                                <tr>
                                    <td>تمدید خودکار</td>
                                    <td>
                                        <?php if($peer->auto_extension): ?>
                                            <a class="btn btn-outline-success btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.togglePeerAutoExtension',$peer->id)); ?>">
                                                <i class="fa fa-toggle-on"></i>
                                            </a>
                                            <?php if($peer->peer_plan): ?>
                                                <?php
                                                $durations = [];
                                                $peerPlan = $peer->peer_plan;
                                                if($peerPlan->duration_year != 0){
                                                    $durations[] = $peerPlan->duration_year.' سال ';
                                                }
                                                if($peerPlan->duration_month != 0){
                                                    $durations[] = $peerPlan->duration_month.' ماه ';
                                                }
                                                if($peerPlan->duration_day != 0){
                                                    $durations[] = $peerPlan->duration_day.' روز ';
                                                }
                                                ?>
                                                 <?php echo e(($peerPlan->traffic/1000)." گیگابایت" . ' - ' . implode(' و ',$durations)); ?>

                                            <?php endif; ?>
                                        <?php else: ?>
                                            <a class="btn btn-outline-danger btn-sm" href="<?php echo e(route('seller.dashboard.users.peer.togglePeerAutoExtension',$peer->id)); ?>">
                                                <i class="fa fa-toggle-off"></i>
                                            </a>
                                        <?php endif; ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <td>شناسه عمومی</td>
                                <td style="direction: ltr" class="wgt-enNumber"><?php echo e($peer->publicKey()); ?></td>
                            </tr>
                            <tr>
                                <td>ایپی داخلی</td>
                                <td style="direction: ltr" class="wgt-enNumber"><?php echo e((new \App\Helper\WireGuardHelper())->getIpFromSubnet($peer->wireguard->ipAddressList,$peer->allowedAddress)); ?></td>
                            </tr>
                            <tr>
                                <td>وضعیت</td>
                                <td>
                                    <?php if($peer->status == App\Status\Peer::ACTIVE): ?>
                                        <span class="badge badge-success">فعال</span>
                                    <?php elseif($peer->status == App\Status\Peer::INACTIVE): ?>
                                        <span class="badge badge-danger">غیر فعال</span>
                                    <?php elseif($peer->status == App\Status\Peer::EXPIRED): ?>
                                        <span class="badge badge-warning">منقضی</span>
                                    <?php else: ?>
                                        <span class="badge badge-warning">نامشخص</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <?php if($peer->is_active()): ?>
                        <div class="row justify-content-center align-center" >
                            <img src="<?php echo e(route('seller.dashboard.users.peer.getConfigQR',$peer->id)); ?>" class="align-center">
                        </div>
                        <div class="row justify-content-center align-center" >
                            <p>
                                جهت استفاده کد را اسکن کنید. میتوانید از پایین فایل QR و یا کانفیگ را دانلود نمایید
                            </p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php if($peer->status == App\Status\Peer::ACTIVE && $peer->PppProfile()): ?>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">کانکشن های PPP</h3>
                    </div>
                    <div class="card-body">
                        <?php if($peer->ppp_secret_l2tp): ?>
                            <div class="text-center">
                                <p class="font-weight-bold" style="font-size: 25px">L2TP</p>
                            </div>
                            <div class="table-wrapper">
                                <table class="table table-striped">
                                    <tr>
                                        <td>دامین</td>
                                        <td class="wgt-enNumber"><?php echo e((($peer->ppp_secret_l2tp->ppp_profile->domain)??($peer->ppp_secret_l2tp->ppp_profile->server->ipAddress))??"نامشخص"); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e((($peer->ppp_secret_l2tp->ppp_profile->domain)??($peer->ppp_secret_l2tp->ppp_profile->server->ipAddress))??""); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>نام کاربری</td>
                                        <td class="wgt-enNumber"><?php echo e($peer->ppp_secret_l2tp->username); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e($peer->ppp_secret_l2tp->username); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>کلمه عبور</td>
                                        <td class="wgt-enNumber"><?php echo e($peer->ppp_secret_l2tp->password); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e($peer->ppp_secret_l2tp->password); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>IPsec</td>
                                        <td class="wgt-enNumber"><?php echo e(($peer->ppp_secret_l2tp->ppp_profile->l2tp_ipsec)??"نامشخص"); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e(($peer->ppp_secret_l2tp->ppp_profile->l2tp_ipsec)??""); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        <?php endif; ?>
                        <?php if($peer->ppp_secret_pptp): ?>
                            <div class="text-center">
                                <p class="font-weight-bold" style="font-size: 25px">PPTP</p>
                            </div>
                            <div class="table-wrapper">
                                <table class="table table-striped">
                                    <tr>
                                        <td>دامین</td>
                                        <td class="wgt-enNumber"><?php echo e((($peer->ppp_secret_pptp->ppp_profile->domain)??($peer->ppp_secret_pptp->ppp_profile->server->ipAddress))??"نامشخص"); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e((($peer->ppp_secret_pptp->ppp_profile->domain)??($peer->ppp_secret_pptp->ppp_profile->server->ipAddress))??""); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>نام کاربری</td>
                                        <td class="wgt-enNumber"><?php echo e($peer->ppp_secret_pptp->username); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e($peer->ppp_secret_pptp->username); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>کلمه عبور</td>
                                        <td class="wgt-enNumber"><?php echo e($peer->ppp_secret_pptp->password); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e($peer->ppp_secret_pptp->password); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        <?php endif; ?>
                        <?php if($peer->ppp_secret_sstp): ?>
                            <div class="text-center">
                                <p class="font-weight-bold" style="font-size: 25px">SSTP</p>
                            </div>
                            <div class="table-wrapper">
                                <table class="table table-striped">
                                    <tr>
                                        <td>دامین</td>
                                        <td class="wgt-enNumber"><?php echo e((($peer->ppp_secret_sstp->ppp_profile->domain)??($peer->ppp_secret_sstp->ppp_profile->server->ipAddress))??"نامشخص"); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e((($peer->ppp_secret_sstp->ppp_profile->domain)??($peer->ppp_secret_sstp->ppp_profile->server->ipAddress))??"نامشخص"); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>نام کاربری</td>
                                        <td class="wgt-enNumber"><?php echo e($peer->ppp_secret_sstp->username); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e($peer->ppp_secret_sstp->username); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>کلمه عبور</td>
                                        <td class="wgt-enNumber"><?php echo e($peer->ppp_secret_sstp->password); ?>

                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('<?php echo e($peer->ppp_secret_sstp->password); ?>');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        <?php endif; ?>
                        <div class="row justify-content-center" style="margin-top: 1rem; gap: 0.5rem">
                            <?php if(!$peer->ppp_secret_l2tp): ?>
                                <div class="form-group">
                                    <button type="button" class="btn btn-block btn-lg" onclick="window.open('<?php echo e(route('seller.dashboard.users.peer.createPPP',[$peer->id,'l2tp'])); ?>','_self')">فعال سازی L2TP</button>
                                </div>
                            <?php endif; ?>
                            <?php if(!$peer->ppp_secret_pptp): ?>
                                <div class="form-group">
                                    <button type="button" class="btn btn-block btn-lg" onclick="window.open('<?php echo e(route('seller.dashboard.users.peer.createPPP',[$peer->id,'pptp'])); ?>','_self')">فعال سازی PPTP</button>
                                </div>
                            <?php endif; ?>
                            <?php if(!$peer->ppp_secret_sstp): ?>
                                <div class="form-group">
                                    <button type="button" class="btn btn-block btn-lg" onclick="window.open('<?php echo e(route('seller.dashboard.users.peer.createPPP',[$peer->id,'sstp'])); ?>','_self')">فعال سازی SSTP</button>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="card">
                <div class="card-body">
                    <div class="row justify-content-center" style="margin-top: 1rem; gap: 0.5rem">
                        <div class="form-group">
                            <button type="button" class="btn btn-block btn-lg" onclick="window.open('<?php echo e(route('seller.dashboard.users.peer.getConfigQR',$peer->id)); ?>','_self')">دانلود فایل QR</button>
                        </div>
                        <div class="form-group">
                            <button type="button" class="btn btn-block btn-lg" onclick="window.open('<?php echo e(route('seller.dashboard.users.peer.getConfig',$peer->id)); ?>','_self')">دانلود فایل کانفیگ</button>
                        </div>
                        <?php if($peer->status == App\Status\Peer::ACTIVE): ?>
                            <div class="form-group">
                                <button type="button" class="btn btn-block btn-lg btn-outline-danger" onclick="window.open('<?php echo e(route('seller.dashboard.users.peer.togglePeerStatus',$peer->id)); ?>','_self')">غیرفعال</button>
                            </div>
                        <?php elseif($peer->status == App\Status\Peer::INACTIVE): ?>
                            <div class="form-group">
                                <button type="button" class="btn btn-block btn-lg btn-outline-success" onclick="window.open('<?php echo e(route('seller.dashboard.users.peer.togglePeerStatus',$peer->id)); ?>','_self')">فعال</button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if($peer->canExtension()): ?>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">تمدید کانکشن</h3>
                    </div>
                    <div class="card-body">
                        <div class="table-wrapper">
                            <table class="table table-striped">
                                <?php $__currentLoopData = \App\Models\PeerPlan::where('status',\App\Status\PeerPlan::ACTIVE)->where('seller_plan_id',auth('seller')->user()->plan_id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $peerPlan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($peerPlan->title); ?></td>
                                        <td>حجم: <?php echo e($peerPlan->traffic?(($peerPlan->traffic/1000)." گیگابایت"):"نامحدود"); ?></td>
                                    <?php
                                        $durations = [];
                                        if($peerPlan->duration_year != 0){
                                            $durations[] = $peerPlan->duration_year.' سال ';
                                        }
                                        if($peerPlan->duration_month != 0){
                                            $durations[] = $peerPlan->duration_month.' ماه ';
                                        }
                                        if($peerPlan->duration_day != 0){
                                            $durations[] = $peerPlan->duration_day.' روز ';
                                        }
                                        ?>
                                        <td>مدت زمان: <?php echo e(implode(' و ',$durations)); ?></td>
                                        <?php
                                        $seller = auth('seller')->user();
                                        $peer_plan_price = $peerPlan->price;
                                        if($seller->plan && $seller->plan->discount_plan>0){
                                            $peer_plan_price *= (1-($seller->plan->discount_plan??0)/100);
                                        }
                                        ?>
                                        <td>قیمت:
                                            <?php if($peerPlan->price != $peer_plan_price): ?>
                                                <del><?php echo e(number_format($peerPlan->price)); ?></del>
                                                <?php echo e(number_format($peer_plan_price)); ?>

                                            <?php else: ?>
                                                <?php echo e(number_format($peerPlan->price)); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-block btn-secondary btn--small plan-btn" onclick="extensionPeer(this,<?php echo e($peerPlan->id); ?>)">خرید</button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            <?php endif; ?>
            <?php if($peer->canDelete()): ?>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">حذف کانکشن</h3>
                    </div>
                    <div class="card-body">
                        <div class="row justify-content-center">
                            <div class="col-lg-6">
                                <button type="button" class="btn btn-block btn-lg btn-danger" onclick="window.open('<?php echo e(route('seller.dashboard.users.peer.delete',$peer->id)); ?>','_self')">حذف</button>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            <?php endif; ?>
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تاریخچه فعالیت کانکشن</h3>
                </div>
                <div class="card-body">
                    <table id="peerLogs" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>تاریخ</th>
                            <th>توضیح</th>
                        </tr>
                        </thead>
                        <tbody>

                        <?php $__currentLoopData = $peer->logs->sortByDesc('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="peerLog-item">
                                <td class="peerLog-item__date">
                                    <time datetime="<?php echo e((jdate($log->created_at))); ?>"><?php echo e((jdate($log->created_at))); ?></time>
                                </td>
                                <td class="peerLog-item__log"><?php echo e((new \App\Helper\Translate())->string($log->log)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
    <div id="editDescription" class="modal">
        <form method="post" action="<?php echo e(route('seller.dashboard.users.peer.editDescription',$peer->id)); ?>">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-lg-12 form-group">
                    <input type="text" name="description" class="form-control" placeholder="توضیحات" value="<?php echo e($peer->description); ?>">
                </div>
                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </div>
        </form>
    </div>
    <div id="trafficTransfer" class="modal">
        <form method="post" action="<?php echo e(route('seller.dashboard.users.peer.trafficTransfer',$peer->id)); ?>">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>کانکشن مبدا</label>
                    <select name="source_peer_id" class="form-control" required>
                        <?php $__currentLoopData = $peer->user->active_peers(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $peer_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($peer->id != $peer_item->id): ?>
                                <option value="<?php echo e($peer_item->id); ?>"><?php echo e($peer_item->id.($peer_item->description?(' - '.$peer_item->description):"")." - حجم: ".(($peer_item->traffic_restrictions/1000) - ($peer_item->traffic_usage_total() + $peer_item->traffic_usage_current()))." GB"); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>مقدار ترافیک (GB)</label>
                    <input type="tel" name="traffic" class="form-control" placeholder="مقدار ترافیک (GB)" value="" step="1" min="1">
                </div>
                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">انتقال</button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script>
        function extensionPeer(e,id){
            let form = document.createElement('form');
            form.setAttribute('method','post');
            form.setAttribute('action','<?php echo e(route('seller.dashboard.users.peer.extension',$peer->id)); ?>');
            let csrf = document.createElement('input');
            csrf.setAttribute('type','hidden');
            csrf.setAttribute('name','_token');
            csrf.setAttribute('value','<?php echo e(csrf_token()); ?>');
            let peer_plan_id = document.createElement('input');
            peer_plan_id.setAttribute('type','hidden');
            peer_plan_id.setAttribute('name','peer_plan_id');
            peer_plan_id.setAttribute('value',id);
            form.appendChild(csrf);
            form.appendChild(peer_plan_id);
            document.body.appendChild(form);
            form.submit();
        }
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script>
        function editDescriptionModal(){
            $('#editDescription').modal({
                showClose: false,
            });
        }
        function trafficTransferModal(){
            $('#trafficTransfer').modal({
                showClose: false,
            });
        }
        function selectTextInDivAndCopy(element) {
            function convertToEnglishNumbers(text) {
                const persianToEnglish = {
                    '۰': '0',
                    '۱': '1',
                    '۲': '2',
                    '۳': '3',
                    '۴': '4',
                    '۵': '5',
                    '۶': '6',
                    '۷': '7',
                    '۸': '8',
                    '۹': '9',
                };
                return text.replace(/[\u06F0-\u06F9]/g, (c) => persianToEnglish[c]);
            }
            const range = document.createRange();
            range.selectNodeContents(element);
            const textWithEnglishNumbers = convertToEnglishNumbers(range.toString());
            const tempElement = document.createElement('div');
            tempElement.textContent = textWithEnglishNumbers;
            document.body.appendChild(tempElement);

            const selection = window.getSelection();
            selection.removeAllRanges();
            range.selectNodeContents(tempElement);
            selection.addRange(range);

            try {
                document.execCommand('copy');
                toastr.info('کپی شد!', null, { timeOut: 1000 });
            } catch (e) {
                toastr.error('مشکلی در کپی کردن به وجود آمد!', null, { timeOut: 1000 });
            }
            document.body.removeChild(tempElement);
        }
        function copyText(text) {
            function convertToEnglishNumbers(text) {
                const persianToEnglish = {
                    '۰': '0',
                    '۱': '1',
                    '۲': '2',
                    '۳': '3',
                    '۴': '4',
                    '۵': '5',
                    '۶': '6',
                    '۷': '7',
                    '۸': '8',
                    '۹': '9',
                };
                return text.replace(/[\u06F0-\u06F9]/g, (c) => persianToEnglish[c]);
            }
            const textWithEnglishNumbers = convertToEnglishNumbers(text);

            const textarea = document.createElement('textarea');
            textarea.value = textWithEnglishNumbers;
            document.body.appendChild(textarea);
            textarea.select();

            try {
                document.execCommand('copy');
                toastr.info('کپی شد!', null, { timeOut: 1000 });
            } catch (e) {
                toastr.error('مشکلی در کپی کردن به وجود آمد!', null, { timeOut: 1000 });
            }
            document.body.removeChild(textarea);
        }
        $("#peerLogs").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('seller.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/muzillagate/public_html/Wire/resources/views/seller/dashboard/users/showPeer.blade.php ENDPATH**/ ?>