<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary">
    <!-- Brand Logo -->
    <a class="brand-link" style="pointer-events: none">
        <span class="brand-text font-weight-light">نمایندگان</span>
        <img src="<?php echo e(asset('/assets/images/sellerAreaLogo.svg')."?v=".env('APP_VERSION')); ?>" class="brand-image img-circle">
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <div>
            <!-- Sidebar user panel (optional) -->
            <div class="user-panel mt-3 pb-3 mb-3 d-flex justify-content-center align-items-center flex-column">
                <div class="avatar rounded-circle">
                    <img  src="https://www.gravatar.com/avatar/<?php echo e(e(md5(strtolower(trim(\Illuminate\Support\Facades\Auth::guard('seller')->user()->email??""))))); ?>?d=mp" class="img-circle elevation-2">
                </div>
                <div class="info mt-2 text-center">
                    <span class="d-block"><?php echo e(\Illuminate\Support\Facades\Auth::guard('seller')->user()->username); ?></span>
                    <span class="d-block">✶<?php echo e(auth('seller')->user()->plan->title??"عمومی"); ?>✶</span>
                    <span class="d-block">
                        موجودی: <?php echo e(number_format(\Illuminate\Support\Facades\Auth::guard('seller')->user()->balance)); ?>

                    </span>
                    <span></span>
                </div>
            </div>


            <!-- Sidebar Menu -->
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                    <li class="nav-item">
                        <a href="<?php echo e(route('seller.dashboard.home')); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.home')) ? "active" : ''); ?>">
                            <i class="nav-icon fa fa-dashboard"></i>
                            <p>داشبورد</p>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="<?php echo e(route('seller.dashboard.users.index')); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.users.*')) ? "active" : ''); ?>">
                            <i class="nav-icon fa fa-users"></i>
                            <p>کاربران</p>
                        </a>
                    </li>

                    <li class="nav-item has-treeview <?php echo e((request()->routeIs('seller.dashboard.peers*')) ? "menu-open" : ''); ?>">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fa fa-link"></i>
                            <p>
                                کانکشن ها
                                <i class="right fa fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('seller.dashboard.peers.listStatus',"ACTIVE")); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.peers.listStatus')&&request('status')=="ACTIVE") ? "active" : ''); ?>">
                                    <i class="fa fa-check nav-icon"></i>
                                    <p>فعال</p>
                                </a>
                            </li>
                        </ul>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('seller.dashboard.peers.listStatus',"INACTIVE")); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.peers.listStatus')&&request('status')=="INACTIVE")? "active" : ''); ?>">
                                    <i class="fa fa-minus nav-icon"></i>
                                    <p>غیرفعال</p>
                                </a>
                            </li>
                        </ul>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('seller.dashboard.peers.listStatus',"canExtension")); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.peers.listStatus')&&request('status')=="canExtension") ? "active" : ''); ?>">
                                    <i class="fa fa-clock-o nav-icon"></i>
                                    <p>قابل تمدید</p>
                                </a>
                            </li>
                        </ul>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('seller.dashboard.peers.listStatus',"EXPIRED")); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.peers.listStatus')&&request('status')=="EXPIRED") ? "active" : ''); ?>">
                                    <i class="fa fa-recycle nav-icon"></i>
                                    <p>منقضی شده</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="nav-item has-treeview <?php echo e((request()->routeIs('seller.dashboard.financial*')) ? "menu-open" : ''); ?>">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fa fa-dollar"></i>
                            <p>
                                مالی
                                <i class="right fa fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('seller.dashboard.financial.increaseWallet')); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.financial.increaseWallet')) ? "active" : ''); ?>">
                                    <i class="fa fa-plus nav-icon"></i>
                                    <p>افزایش موجودی</p>
                                </a>
                            </li>
                        </ul>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('seller.dashboard.financial.validTransactions')); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.financial.validTransactions')) ? "active" : ''); ?>">
                                    <i class="fa fa-check nav-icon"></i>
                                    <p>تراکنش های معتبر</p>
                                </a>
                            </li>
                        </ul>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('seller.dashboard.financial.walletHistory')); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.financial.walletHistory')) ? "active" : ''); ?>">
                                    <i class="fa fa-history nav-icon"></i>
                                    <p>تاریخچه کیف پول</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item has-treeview <?php echo e((request()->routeIs('seller.dashboard.more*')) ? "menu-open" : ''); ?>">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fa fa-bars"></i>
                            <p>
                                بیشتر
                                <i class="right fa fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('seller.dashboard.more.change_password')); ?>" class="nav-link <?php echo e((request()->routeIs('seller.dashboard.more.change_password')) ? "active" : ''); ?>">
                                    <i class="fa fa-key nav-icon"></i>
                                    <p>تغییر کلمه عبور</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a href="https://wiki.wiregate.net/Alpha" class="nav-link">
                            <i class="nav-icon fa fa-book"></i>
                            <p>راهنما
                                <span class="right badge badge-warning">درحال آماده سازی</span>
                            </p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('seller.auth.logout')); ?>" class="nav-link">
                            <i class="nav-icon fa fa-power-off"></i>
                            <p>خروج</p>
                        </a>
                    </li>
                </ul>
            </nav>
            <!-- /.sidebar-menu -->
        </div>
    </div>
    <!-- /.sidebar -->
</aside>
<?php /**PATH /home/muzillagate/public_html/Wire/resources/views/seller/dashboard/main/left-sidebar.blade.php ENDPATH**/ ?>