<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary">
    <!-- Brand Logo -->
    <a class="brand-link" style="pointer-events: none">
        <span class="brand-text font-weight-light">ادمین</span>
        <img src="<?php echo e(asset('/assets/images/sellerAreaLogo.svg')."?v=".env('APP_VERSION')); ?>" class="brand-image img-circle">
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <div>
            <!-- Sidebar user panel (optional) -->
            <div class="user-panel mt-3 pb-3 mb-3 d-flex justify-content-center align-items-center flex-column">
                <div class="avatar rounded-circle">
                    <img  src="https://www.gravatar.com/avatar/<?php echo e(e(md5(strtolower(trim(\Illuminate\Support\Facades\Auth::guard('admin')->user()->email??""))))); ?>?d=mp" class="img-circle elevation-2">
                </div>
                <div class="info mt-2 text-center">
                    <span class="d-block"><?php echo e(\Illuminate\Support\Facades\Auth::guard('admin')->user()->username); ?></span>
                    <span></span>
                </div>
            </div>


            <!-- Sidebar Menu -->
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.dashboard.home')); ?>" class="nav-link <?php echo e((request()->routeIs('admin.dashboard.home')) ? "active" : ''); ?>">
                            <i class="nav-icon fa fa-dashboard"></i>
                            <p>داشبورد</p>
                        </a>
                    </li>
                    <li class="nav-item has-treeview <?php echo e((request()->routeIs('admin.dashboard.servers.*')) ? "menu-open" : ''); ?>">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fa fa-server"></i>
                            <p>
                                سرورها
                                <i class="right fa fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.dashboard.servers.list')); ?>" class="nav-link <?php echo e((request()->routeIs('admin.dashboard.servers.list')) ? "active" : ''); ?>">
                                    <i class="fa fa-link nav-icon"></i>
                                    <p>لیست سرورها</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item has-treeview <?php echo e((request()->routeIs('admin.dashboard.sellers.*')) ? "menu-open" : ''); ?>">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fa fa-users"></i>
                            <p>
                                نمایندگان
                                <i class="right fa fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.dashboard.sellers.list')); ?>" class="nav-link <?php echo e((request()->routeIs('admin.dashboard.sellers.list')) ? "active" : ''); ?>">
                                    <i class="fa fa-list nav-icon"></i>
                                    <p>لیست نمایندگان</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.dashboard.sellers.plans.list')); ?>" class="nav-link <?php echo e((request()->routeIs('admin.dashboard.sellers.plans*')) ? "active" : ''); ?>">
                                    <i class="fa fa-plane nav-icon"></i>
                                    <p>پلن ها</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item has-treeview <?php echo e((request()->routeIs('admin.dashboard.more*')) ? "menu-open" : ''); ?>">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fa fa-bars"></i>
                            <p>
                                بیشتر
                                <i class="right fa fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.dashboard.more.change_password')); ?>" class="nav-link <?php echo e((request()->routeIs('admin.dashboard.more.change_password')) ? "active" : ''); ?>">
                                    <i class="fa fa-key nav-icon"></i>
                                    <p>تغییر کلمه عبور</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.auth.logout')); ?>" class="nav-link">
                            <i class="nav-icon fa fa-power-off"></i>
                            <p>خروج</p>
                        </a>
                    </li>
                </ul>
            </nav>
            <!-- /.sidebar-menu -->
        </div>
    </div>
    <!-- /.sidebar -->
</aside>
<?php /**PATH /home/muzillagate/public_html/Wire/resources/views/admin/dashboard/main/left-sidebar.blade.php ENDPATH**/ ?>