<?php $__env->startSection('title','لیست نمایندگان'); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">لیست نمایندگان</h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('admin.dashboard.sellers.list')); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">لیست نمایندگان</h3>
                    <div class="card-tools">
                        <a href="#addPlan" class="btn btn-success" onclick="addSellerModal()">+</a>
                    </div>
                </div>
                <div class="card-body">
                    <table id="sellersTable" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>نام کاربری</th>
                            <th>شماره تماس</th>
                            <th>ایمیل</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $sellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($seller->username); ?></td>
                                <td><?php echo e($seller->phone); ?></td>
                                <td><?php echo e($seller->email); ?></td>
                                <td>
                                    <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('admin.dashboard.sellers.show',$seller->id)); ?>">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>نام کاربری</th>
                            <th>شماره تماس</th>
                            <th>ایمیل</th>
                            <th>عملیات</th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
    <div id="addSeller" class="modal">
        <form method="post" action="<?php echo e(route('admin.dashboard.sellers.add')); ?>">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>نام کاربری</label>
                    <input type="text" name="username" class="form-control" placeholder="نام کاربری">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>شماره تماس</label>
                    <input type="text" name="phone" class="form-control" placeholder="شماره تماس">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>ایمیل</label>
                    <input type="email" name="email" class="form-control" placeholder="ایمیل">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>رمز عبور</label>
                    <input type="password" name="password" class="form-control" placeholder="رمز عبور">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>تکرار رمز عبور</label>
                    <input type="password" name="password_confirmation" class="form-control" placeholder="تکرار رمز عبور">
                </div>

                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script>
        $("#sellersTable").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script>
        function editUserModal(userId){
            $('#editUser-'+userId).modal({
                showClose: false,
            });
        }
        function addSellerModal(){
            $('#addSeller').modal({
                showClose: false,
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/muzillagate/public_html/Wire/resources/views/admin/dashboard/seller/index.blade.php ENDPATH**/ ?>