<?php $__env->startSection('title',$user->username); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"><?php echo e($user->username); ?></h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('seller.dashboard.users.show',$user)); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-md-12">
        <div class="card card-cyan">
            <div class="card-body">
                <table class="table table-striped">
                    <tr>
                        <td>نام کاربری</td>
                        <td><?php echo e($user->username); ?></td>
                    </tr>
                    <tr>
                        <td>تلفن همراه</td>
                        <td><?php echo e($user->phone); ?></td>
                    </tr>
                    <tr>
                        <td>وضعیت</td>
                        <td>
                            <?php if($user->status == App\Status\User::ACTIVE): ?>
                                <span class="badge badge-success">فعال</span>
                            <?php elseif($user->status == App\Status\User::INACTIVE): ?>
                                <span class="badge badge-danger">غیر فعال</span>
                            <?php else: ?>
                                <span class="badge badge-warning">نامشخص</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>

            </div>
        </div>

        <div class="card card-success">
            <div class="card-header">
                <h3 class="card-title">کانکشن ها</h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('seller.dashboard.users.addPeer',$user->id)); ?>" class="btn btn-success" style="border-color: #fff;">خرید</a>
                </div>
            </div>
            <div class="card-body">
                <table id="peerHistory" class="table table-bordered table-hover">
                    <thead>
                    <tr>
                        <th>عنوان کانکشن</th>
                        <th>کشور</th>
                        <th>حجم کل</th>
                        <th>حجم مصرفی</th>
                        <th>زمان پایان</th>
                        <th>وضعیت</th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php $__currentLoopData = $user->peers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $peer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="peer-item">
                            <td class="peer-item__title">
                                <?php echo e($peer->wireguard->title); ?>

                            </td>
                            <td class="peer-item__country">
                                <?php echo e($peer->wireguard->location); ?>

                            </td>
                            <td class="peer-item__traffic_restrictions">
                                <?php echo e($peer->traffic_restrictions/1000); ?> GB
                            </td>
                            <td class="peer-item__traffic_usage_total">
                                <?php echo e($peer->traffic_usage_current + $peer->traffic_usage_total); ?> GB
                            </td>
                            <td class="peer-item__expired_at">
                                <?php echo e(jdate($peer->expires_at)); ?>

                            </td>
                            <td class="peer-item__status">
                                <?php if($peer->status == App\Status\Peer::ACTIVE): ?>
                                    <span class="badge badge-success">فعال</span>
                                    <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('seller.dashboard.users.getConfig',$peer->id)); ?>">
                                        <i class="fa fa-download"></i>
                                    </a>
                                <?php elseif($peer->status == App\Status\Peer::INACTIVE): ?>
                                    <span class="badge badge-danger">غیر فعال</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">نامشخص</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')); ?>"></script>
    <script>
        $("#peerHistory").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
        });

        $("#addPeer").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('seller.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH H:\work\ariya\wiregate\wiregate-alpha\resources\views/seller/dashboard/users/show.blade.php ENDPATH**/ ?>