<?php $__env->startSection('title','تراکنش های معتبر'); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">تراکنش های معتبر</h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('seller.dashboard.financial.validTransactions')); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        function destroyString($string){
            if (strlen($string) > 6) {
                $start = substr($string, 0, 7); // extract the first 5 characters
                $end = substr($string, -7); // extract the last 8 characters

                $middle = '...'; // placeholder for the middle portion
                $result = $start . $middle . $end;
            } else {
                $result = $string; // if the string is already shorter than the maximum length
            }
            return $result;
        }
    ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تراکنش های معتبر</h3>
                </div>
                <div class="card-body">
                    <table id="Transactions" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>نماد</th>
                            <th>TransactionID</th>
                            <th>از</th>
                            <th>به</th>
                            <th>مقدار</th>
                            <th>نرخ ارز</th>
                            <th>زمان ثبت</th>
                            <th>وضعیت</th>
                        </tr>
                        </thead>
                        <tbody>

                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($transaction->symbol); ?></td>
                                <td class="wgt-enNumber"><?php echo e(destroyString($transaction->transaction_id)); ?></td>
                                <td class="wgt-enNumber"><?php echo e(destroyString($transaction->from_wallet)??"نامشخص"); ?></td>
                                <td class="wgt-enNumber"><?php echo e(destroyString($transaction->wallet)); ?></td>
                                <td><?php echo e((($transaction->amount))); ?></td>
                                <td><?php echo e(number_format($transaction->IRT_rate)); ?></td>
                                <td><?php echo e(jdate($transaction->created_at)); ?></td>
                                <td>
                                    <?php if($transaction->status == App\Status\SellerTransaction::NEW): ?>
                                        <span class="badge badge-primary">درحال بررسی</span>
                                    <?php elseif($transaction->status == App\Status\SellerTransaction::SUCCESS): ?>
                                        <span class="badge badge-success">موفق</span>
                                    <?php elseif($transaction->status == App\Status\SellerTransaction::FAILED): ?>
                                        <span class="badge badge-danger">ناموفق</span>
                                    <?php else: ?>
                                        <span class="badge badge-warning">نامشخص</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')); ?>"></script>
    <script>
        $("#Transactions").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('seller.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/muzillagate/public_html/Wire/resources/views/seller/dashboard/financial/validTransactions.blade.php ENDPATH**/ ?>