<?php $__env->startSection('title','کاربران'); ?>

<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">کاربران</h1>
                </div><!-- /.col -->
                <?php echo e(Breadcrumbs::render('seller.dashboard.users.index')); ?>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-md-12">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">کابران</h3>
            </div>
            <div class="card-body">
                <table id="usersTable" class="table table-bordered table-hover">
                    <thead>
                    <tr>
                        <th>نام کاربری</th>
                        <th>تلفن همراه</th>
                        <th>تعداد کانکشن</th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr onclick="window.open('<?php echo e(route('seller.dashboard.users.show',$user->id)); ?>','_blank')">
                            <td><?php echo e($user->username); ?></td>
                            <td><?php echo e($user->phone); ?></td>
                            <td><?php echo e(count($user->peers)); ?> عدد</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                    <tfoot>
                    <tr>
                        <th>نام کاربری</th>
                        <th>تلفن همراه</th>
                        <th>تعداد کانکشن</th>
                    </tr>
                    </tfoot>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <div class="card card-outline card-success">
            <div class="card-header">
                <h3 class="card-title">افزودن کاربر</h3>
            </div>
            <form action="<?php echo e(route('seller.dashboard.users.addUser')); ?>"  method="post">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <input type="text" name="username" class="form-control" placeholder="نام کاربری" required>
                        </div>
                        <div class="col-6">
                            <input type="text" name="phone" class="form-control" placeholder="تلفن همراه" required>
                        </div>

                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </form>
            <!-- /.card-body -->
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('end_body'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.js')); ?>"></script>
    <script>
        $("#usersTable").DataTable({
            ordering: true,
            searching: true,
            paging: true,
            info: false,
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('seller.dashboard.main.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH H:\work\ariya\wiregate\wiregate-alpha\resources\views/seller/dashboard/users/index.blade.php ENDPATH**/ ?>