<?php // routes/breadcrumbs.php

// Note: Laravel will automatically resolve `Breadcrumbs::` without
// this import. This is nice for IDE syntax and refactoring.
use Diglactic\Breadcrumbs\Breadcrumbs;

// This import is also not required, and you could replace `BreadcrumbTrail $trail`
//  with `$trail`. This is nice for IDE type checking and completion.
use Diglactic\Breadcrumbs\Generator as BreadcrumbTrail;


Breadcrumbs::for('seller.dashboard.home', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('خانه', route('seller.dashboard.home'));
});
Breadcrumbs::for('seller.dashboard.more.change_password', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('بیشتر');
    $trail->push('تغییر کلمه عبور', route('seller.dashboard.more.change_password'));
});

Breadcrumbs::for('seller.dashboard.users.index', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('کاربران');
});
Breadcrumbs::for('seller.dashboard.users.show', function (BreadcrumbTrail $trail, $user) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('کاربران', route('seller.dashboard.users.index'));
    $trail->push($user->username);
});
Breadcrumbs::for('seller.dashboard.users.addPeer', function (BreadcrumbTrail $trail, $user) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('کاربران', route('seller.dashboard.users.index'));
    $trail->push($user->username, route('seller.dashboard.users.show', $user->id));
    $trail->push("خرید کانکشن");
});
Breadcrumbs::for('seller.dashboard.users.peer.showPeer', function (BreadcrumbTrail $trail, $peer) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('کاربران', route('seller.dashboard.users.index'));
    $trail->push($peer->user->username, route('seller.dashboard.users.show', $peer->user->id));
    $trail->push($peer->description??'نامشخص');
});
Breadcrumbs::for('seller.dashboard.financial.walletHistory', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('مالی');
    $trail->push('تاریخچه کیف پول', route('seller.dashboard.financial.walletHistory'));
});
Breadcrumbs::for('seller.dashboard.financial.increaseWallet', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('مالی');
    $trail->push('افزایش موجودی', route('seller.dashboard.financial.increaseWallet'));
});
Breadcrumbs::for('seller.dashboard.financial.validTransactions', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('مالی');
    $trail->push('تراکنش های معتبر', route('seller.dashboard.financial.validTransactions'));
});
Breadcrumbs::for('seller.dashboard.peers.listStatus', function (BreadcrumbTrail $trail, $status) {
    $trail->push('داشبورد', route('seller.dashboard.home'));
    $trail->push('کانکشن ها');
    $trail->push(__($status), route('seller.dashboard.peers.listStatus', $status));
});



Breadcrumbs::for('admin.dashboard.home', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('admin.dashboard.home'));
    $trail->push('خانه', route('admin.dashboard.home'));
});
Breadcrumbs::for('admin.dashboard.more.change_password', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('admin.dashboard.home'));
    $trail->push('بیشتر');
    $trail->push('تغییر کلمه عبور', route('admin.dashboard.more.change_password'));
});
Breadcrumbs::for('admin.dashboard.servers.list', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('admin.dashboard.home'));
    $trail->push('سرورها');
    $trail->push('لیست سرورها', route('admin.dashboard.servers.list'));
});

Breadcrumbs::for('admin.dashboard.servers.show', function (BreadcrumbTrail $trail,$server) {
    $trail->push('داشبورد', route('admin.dashboard.home'));
    $trail->push('سرورها');
    $trail->push('لیست سرورها', route('admin.dashboard.servers.list'));
    $trail->push($server->title??"نامشخص", route('admin.dashboard.servers.show',$server->id));
});

Breadcrumbs::for('admin.dashboard.sellers.list', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('admin.dashboard.home'));
    $trail->push('نمایندگان');
    $trail->push('لیست نمایندگان', route('admin.dashboard.sellers.list'));
});

Breadcrumbs::for('admin.dashboard.sellers.show', function (BreadcrumbTrail $trail,$seller) {
    $trail->push('داشبورد', route('admin.dashboard.home'));
    $trail->push('نمایندگان');
    $trail->push('لیست نمایندگان', route('admin.dashboard.sellers.list'));
    $trail->push($seller->username??"نامشخص", route('admin.dashboard.sellers.show',$seller->id));
});
Breadcrumbs::for('admin.dashboard.sellers.wallet', function (BreadcrumbTrail $trail, $seller) {
    $trail->push('داشبورد', route('admin.dashboard.home'));
    $trail->push('نمایندگان');
    $trail->push('لیست نمایندگان', route('admin.dashboard.sellers.list'));
    $trail->push($seller->username??"نامشخص", route('admin.dashboard.sellers.show',$seller->id));
    $trail->push('کیف پول', route('admin.dashboard.sellers.wallet',$seller->id));
});

Breadcrumbs::for('admin.dashboard.sellers.plans.list', function (BreadcrumbTrail $trail) {
    $trail->push('داشبورد', route('admin.dashboard.home'));
    $trail->push('نمایندگان');
    $trail->push('پلن ها', route('admin.dashboard.sellers.plans.list'));
});
