@extends('seller.dashboard.main.main')
@section('title',$peer->user->username.' - '.($peer->description??'نامشخص'))

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{$peer->description??'نامشخص'}}</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('seller.dashboard.users.peer.showPeer',$peer) }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />
    <link rel="stylesheet" href="{{asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')}}">
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-cyan">
                <div class="card-body">
                    <div class="table-wrapper">
                        <table class="table table-striped">
                            <tr>
                                <td>شناسه کانکشن</td>
                                <td>{{$peer->id}}</td>
                            </tr>
                            <td>شناسه یکتا</td>
                            <td>
                                @if(!$peer->unique_id)
                                    <a class="btn btn-sm" href="{{route('seller.dashboard.users.peer.refreshUniqueId',$peer->id)}}">ایجاد شناسه یکتا</a>
                                @else
                                    <div style="display: ruby">
                                        <div type="text" class="form-control" style="text-align: center; background: #ececec;width: fit-content;" onclick="selectTextInDivAndCopy(this);">{{$peer->unique_id}}</div>
                                        <a class="btn btn-sm" href="{{route('seller.dashboard.users.peer.refreshUniqueId',$peer->id)}}">تغییر شناسه یکتا</a>
                                    </div>
                                @endif
                            </td>
                            <tr>
                                <td>کشور</td>
                                <td>{{$peer->wireguard->location}}</td>
                            </tr>
                            <tr>
                                <td>حجم کل</td>
                                <td>{{$peer->traffic_restrictions/1000}} GB
                                    @if(count($peer->user->active_peers())>=2)
                                        <a class="btn  btn-sm" href="#trafficTransfer" onclick="trafficTransferModal()">
                                            <i class="fa fa-plus text-secondary"></i>
                                        </a>
                                    @endif
                                </td>

                            </tr>
                            <tr>
                                <td>حجم مصرفی</td>
                                <td>{{$peer->traffic_usage_current() + $peer->traffic_usage_total()}} GB</td>
                            </tr>
                            <tr>
                                <td>زمان پایان</td>
                                <td>{{jdate($peer->expires_at)}}</td>
                            </tr>
                            <tr>
                                <td>توضیحات</td>
                                <td>{{$peer->description??'نامشخص'}}
                                    <a class="btn btn-sm" href="#editDescription" onclick="editDescriptionModal()">
                                        <i class="fa fa-edit text-secondary"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>وضعیت تمدید</td>
                                <td>{{$peer->extension_plan->title??"تمدید نشده"}}</td>
                            </tr>
                            @if((($peer->auto_extension) || ($peer->peer_plan_id!=null)))
                                <tr>
                                    <td>تمدید خودکار</td>
                                    <td>
                                        @if($peer->auto_extension)
                                            <a class="btn btn-outline-success btn-sm" href="{{route('seller.dashboard.users.peer.togglePeerAutoExtension',$peer->id)}}">
                                                <i class="fa fa-toggle-on"></i>
                                            </a>
                                            @if($peer->peer_plan)
                                                <?php
                                                $durations = [];
                                                $peerPlan = $peer->peer_plan;
                                                if($peerPlan->duration_year != 0){
                                                    $durations[] = $peerPlan->duration_year.' سال ';
                                                }
                                                if($peerPlan->duration_month != 0){
                                                    $durations[] = $peerPlan->duration_month.' ماه ';
                                                }
                                                if($peerPlan->duration_day != 0){
                                                    $durations[] = $peerPlan->duration_day.' روز ';
                                                }
                                                ?>
                                                 {{($peerPlan->traffic/1000)." گیگابایت" . ' - ' . implode(' و ',$durations)}}
                                            @endif
                                        @else
                                            <a class="btn btn-outline-danger btn-sm" href="{{route('seller.dashboard.users.peer.togglePeerAutoExtension',$peer->id)}}">
                                                <i class="fa fa-toggle-off"></i>
                                            </a>
                                        @endif

                                    </td>
                                </tr>
                            @endif
                            <tr>
                                <td>شناسه عمومی</td>
                                <td style="direction: ltr" class="wgt-enNumber">{{$peer->publicKey()}}</td>
                            </tr>
                            <tr>
                                <td>ایپی داخلی</td>
                                <td style="direction: ltr" class="wgt-enNumber">{{(new \App\Helper\WireGuardHelper())->getIpFromSubnet($peer->wireguard->ipAddressList,$peer->allowedAddress)}}</td>
                            </tr>
                            <tr>
                                <td>وضعیت</td>
                                <td>
                                    @if($peer->status == App\Status\Peer::ACTIVE)
                                        <span class="badge badge-success">فعال</span>
                                    @elseif($peer->status == App\Status\Peer::INACTIVE)
                                        <span class="badge badge-danger">غیر فعال</span>
                                    @elseif($peer->status == App\Status\Peer::EXPIRED)
                                        <span class="badge badge-warning">منقضی</span>
                                    @else
                                        <span class="badge badge-warning">نامشخص</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                    @if($peer->is_active())
                        <div class="row justify-content-center align-center" >
                            <img src="{{route('seller.dashboard.users.peer.getConfigQR',$peer->id)}}" class="align-center">
                        </div>
                        <div class="row justify-content-center align-center" >
                            <p>
                                جهت استفاده کد را اسکن کنید. میتوانید از پایین فایل QR و یا کانفیگ را دانلود نمایید
                            </p>
                        </div>
                    @endif
                </div>
            </div>
            @if($peer->status == App\Status\Peer::ACTIVE && $peer->PppProfile())
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">کانکشن های PPP</h3>
                    </div>
                    <div class="card-body">
                        @if($peer->ppp_secret_l2tp)
                            <div class="text-center">
                                <p class="font-weight-bold" style="font-size: 25px">L2TP</p>
                            </div>
                            <div class="table-wrapper">
                                <table class="table table-striped">
                                    <tr>
                                        <td>دامین</td>
                                        <td class="wgt-enNumber">{{(($peer->ppp_secret_l2tp->ppp_profile->domain)??($peer->ppp_secret_l2tp->ppp_profile->server->ipAddress))??"نامشخص"}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{(($peer->ppp_secret_l2tp->ppp_profile->domain)??($peer->ppp_secret_l2tp->ppp_profile->server->ipAddress))??""}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>نام کاربری</td>
                                        <td class="wgt-enNumber">{{$peer->ppp_secret_l2tp->username}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{$peer->ppp_secret_l2tp->username}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>کلمه عبور</td>
                                        <td class="wgt-enNumber">{{$peer->ppp_secret_l2tp->password}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{$peer->ppp_secret_l2tp->password}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>IPsec</td>
                                        <td class="wgt-enNumber">{{($peer->ppp_secret_l2tp->ppp_profile->l2tp_ipsec)??"نامشخص"}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{($peer->ppp_secret_l2tp->ppp_profile->l2tp_ipsec)??""}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        @endif
                        @if($peer->ppp_secret_pptp)
                            <div class="text-center">
                                <p class="font-weight-bold" style="font-size: 25px">PPTP</p>
                            </div>
                            <div class="table-wrapper">
                                <table class="table table-striped">
                                    <tr>
                                        <td>دامین</td>
                                        <td class="wgt-enNumber">{{(($peer->ppp_secret_pptp->ppp_profile->domain)??($peer->ppp_secret_pptp->ppp_profile->server->ipAddress))??"نامشخص"}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{(($peer->ppp_secret_pptp->ppp_profile->domain)??($peer->ppp_secret_pptp->ppp_profile->server->ipAddress))??""}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>نام کاربری</td>
                                        <td class="wgt-enNumber">{{$peer->ppp_secret_pptp->username}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{$peer->ppp_secret_pptp->username}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>کلمه عبور</td>
                                        <td class="wgt-enNumber">{{$peer->ppp_secret_pptp->password}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{$peer->ppp_secret_pptp->password}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        @endif
                        @if($peer->ppp_secret_sstp)
                            <div class="text-center">
                                <p class="font-weight-bold" style="font-size: 25px">SSTP</p>
                            </div>
                            <div class="table-wrapper">
                                <table class="table table-striped">
                                    <tr>
                                        <td>دامین</td>
                                        <td class="wgt-enNumber">{{(($peer->ppp_secret_sstp->ppp_profile->domain)??($peer->ppp_secret_sstp->ppp_profile->server->ipAddress))??"نامشخص"}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{(($peer->ppp_secret_sstp->ppp_profile->domain)??($peer->ppp_secret_sstp->ppp_profile->server->ipAddress))??"نامشخص"}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>نام کاربری</td>
                                        <td class="wgt-enNumber">{{$peer->ppp_secret_sstp->username}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{$peer->ppp_secret_sstp->username}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>کلمه عبور</td>
                                        <td class="wgt-enNumber">{{$peer->ppp_secret_sstp->password}}
                                            <a class="btn  btn-sm" href="#trafficTransfer" onclick="copyText('{{$peer->ppp_secret_sstp->password}}');">
                                                <i class="fa fa-copy text-secondary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        @endif
                        <div class="row justify-content-center" style="margin-top: 1rem; gap: 0.5rem">
                            @if(!$peer->ppp_secret_l2tp)
                                <div class="form-group">
                                    <button type="button" class="btn btn-block btn-lg" onclick="window.open('{{route('seller.dashboard.users.peer.createPPP',[$peer->id,'l2tp'])}}','_self')">فعال سازی L2TP</button>
                                </div>
                            @endif
                            @if(!$peer->ppp_secret_pptp)
                                <div class="form-group">
                                    <button type="button" class="btn btn-block btn-lg" onclick="window.open('{{route('seller.dashboard.users.peer.createPPP',[$peer->id,'pptp'])}}','_self')">فعال سازی PPTP</button>
                                </div>
                            @endif
                            @if(!$peer->ppp_secret_sstp)
                                <div class="form-group">
                                    <button type="button" class="btn btn-block btn-lg" onclick="window.open('{{route('seller.dashboard.users.peer.createPPP',[$peer->id,'sstp'])}}','_self')">فعال سازی SSTP</button>
                                </div>
                            @endif

                        </div>
                    </div>
                </div>
            @endif
            <div class="card">
                <div class="card-body">
                    <div class="row justify-content-center" style="margin-top: 1rem; gap: 0.5rem">
                        <div class="form-group">
                            <button type="button" class="btn btn-block btn-lg" onclick="window.open('{{route('seller.dashboard.users.peer.getConfigQR',$peer->id)}}','_self')">دانلود فایل QR</button>
                        </div>
                        <div class="form-group">
                            <button type="button" class="btn btn-block btn-lg" onclick="window.open('{{route('seller.dashboard.users.peer.getConfig',$peer->id)}}','_self')">دانلود فایل کانفیگ</button>
                        </div>
                        @if($peer->status == App\Status\Peer::ACTIVE)
                            <div class="form-group">
                                <button type="button" class="btn btn-block btn-lg btn-outline-danger" onclick="window.open('{{route('seller.dashboard.users.peer.togglePeerStatus',$peer->id)}}','_self')">غیرفعال</button>
                            </div>
                        @elseif($peer->status == App\Status\Peer::INACTIVE)
                            <div class="form-group">
                                <button type="button" class="btn btn-block btn-lg btn-outline-success" onclick="window.open('{{route('seller.dashboard.users.peer.togglePeerStatus',$peer->id)}}','_self')">فعال</button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            @if($peer->canExtension())
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">تمدید کانکشن</h3>
                    </div>
                    <div class="card-body">
                        <div class="table-wrapper">
                            <table class="table table-striped">
                                @foreach(\App\Models\PeerPlan::where('status',\App\Status\PeerPlan::ACTIVE)->where('seller_plan_id',auth('seller')->user()->plan_id)->get() as $peerPlan)
                                    <tr>
                                        <td>{{$peerPlan->title}}</td>
                                        <td>حجم: {{$peerPlan->traffic?(($peerPlan->traffic/1000)." گیگابایت"):"نامحدود"}}</td>
                                    <?php
                                        $durations = [];
                                        if($peerPlan->duration_year != 0){
                                            $durations[] = $peerPlan->duration_year.' سال ';
                                        }
                                        if($peerPlan->duration_month != 0){
                                            $durations[] = $peerPlan->duration_month.' ماه ';
                                        }
                                        if($peerPlan->duration_day != 0){
                                            $durations[] = $peerPlan->duration_day.' روز ';
                                        }
                                        ?>
                                        <td>مدت زمان: {{implode(' و ',$durations)}}</td>
                                        <?php
                                        $seller = auth('seller')->user();
                                        $peer_plan_price = $peerPlan->price;
                                        if($seller->plan && $seller->plan->discount_plan>0){
                                            $peer_plan_price *= (1-($seller->plan->discount_plan??0)/100);
                                        }
                                        ?>
                                        <td>قیمت:
                                            @if($peerPlan->price != $peer_plan_price)
                                                <del>{{number_format($peerPlan->price)}}</del>
                                                {{number_format($peer_plan_price)}}
                                            @else
                                                {{number_format($peerPlan->price)}}
                                            @endif
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-block btn-secondary btn--small plan-btn" onclick="extensionPeer(this,{{$peerPlan->id}})">خرید</button>
                                        </td>
                                    </tr>
                                @endforeach
                            </table>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            @endif
            @if($peer->canDelete())
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">حذف کانکشن</h3>
                    </div>
                    <div class="card-body">
                        <div class="row justify-content-center">
                            <div class="col-lg-6">
                                <button type="button" class="btn btn-block btn-lg btn-danger" onclick="window.open('{{route('seller.dashboard.users.peer.delete',$peer->id)}}','_self')">حذف</button>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            @endif
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تاریخچه فعالیت کانکشن</h3>
                </div>
                <div class="card-body">
                    <table id="peerLogs" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>تاریخ</th>
                            <th>توضیح</th>
                        </tr>
                        </thead>
                        <tbody>

                        @foreach($peer->logs->sortByDesc('created_at') as $log)
                            <tr class="peerLog-item">
                                <td class="peerLog-item__date">
                                    <time datetime="{{(jdate($log->created_at))}}">{{(jdate($log->created_at))}}</time>
                                </td>
                                <td class="peerLog-item__log">{{(new \App\Helper\Translate())->string($log->log)}}</td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
    <div id="editDescription" class="modal">
        <form method="post" action="{{route('seller.dashboard.users.peer.editDescription',$peer->id)}}">
            @csrf
            <div class="row">
                <div class="col-lg-12 form-group">
                    <input type="text" name="description" class="form-control" placeholder="توضیحات" value="{{$peer->description}}">
                </div>
                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </div>
        </form>
    </div>
    <div id="trafficTransfer" class="modal">
        <form method="post" action="{{route('seller.dashboard.users.peer.trafficTransfer',$peer->id)}}">
            @csrf
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>کانکشن مبدا</label>
                    <select name="source_peer_id" class="form-control" required>
                        @foreach($peer->user->active_peers() as $peer_item)
                            @if($peer->id != $peer_item->id)
                                <option value="{{$peer_item->id}}">{{$peer_item->id.($peer_item->description?(' - '.$peer_item->description):"")." - حجم: ".(($peer_item->traffic_restrictions/1000) - ($peer_item->traffic_usage_total() + $peer_item->traffic_usage_current()))." GB"}}</option>
                            @endif
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>مقدار ترافیک (GB)</label>
                    <input type="tel" name="traffic" class="form-control" placeholder="مقدار ترافیک (GB)" value="" step="1" min="1">
                </div>
                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">انتقال</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('end_body')
    <script>
        function extensionPeer(e,id){
            let form = document.createElement('form');
            form.setAttribute('method','post');
            form.setAttribute('action','{{route('seller.dashboard.users.peer.extension',$peer->id)}}');
            let csrf = document.createElement('input');
            csrf.setAttribute('type','hidden');
            csrf.setAttribute('name','_token');
            csrf.setAttribute('value','{{csrf_token()}}');
            let peer_plan_id = document.createElement('input');
            peer_plan_id.setAttribute('type','hidden');
            peer_plan_id.setAttribute('name','peer_plan_id');
            peer_plan_id.setAttribute('value',id);
            form.appendChild(csrf);
            form.appendChild(peer_plan_id);
            document.body.appendChild(form);
            form.submit();
        }
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script src="{{asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')}}"></script>
    <script>
        function editDescriptionModal(){
            $('#editDescription').modal({
                showClose: false,
            });
        }
        function trafficTransferModal(){
            $('#trafficTransfer').modal({
                showClose: false,
            });
        }
        function selectTextInDivAndCopy(element) {
            function convertToEnglishNumbers(text) {
                const persianToEnglish = {
                    '۰': '0',
                    '۱': '1',
                    '۲': '2',
                    '۳': '3',
                    '۴': '4',
                    '۵': '5',
                    '۶': '6',
                    '۷': '7',
                    '۸': '8',
                    '۹': '9',
                };
                return text.replace(/[\u06F0-\u06F9]/g, (c) => persianToEnglish[c]);
            }
            const range = document.createRange();
            range.selectNodeContents(element);
            const textWithEnglishNumbers = convertToEnglishNumbers(range.toString());
            const tempElement = document.createElement('div');
            tempElement.textContent = textWithEnglishNumbers;
            document.body.appendChild(tempElement);

            const selection = window.getSelection();
            selection.removeAllRanges();
            range.selectNodeContents(tempElement);
            selection.addRange(range);

            try {
                document.execCommand('copy');
                toastr.info('کپی شد!', null, { timeOut: 1000 });
            } catch (e) {
                toastr.error('مشکلی در کپی کردن به وجود آمد!', null, { timeOut: 1000 });
            }
            document.body.removeChild(tempElement);
        }
        function copyText(text) {
            function convertToEnglishNumbers(text) {
                const persianToEnglish = {
                    '۰': '0',
                    '۱': '1',
                    '۲': '2',
                    '۳': '3',
                    '۴': '4',
                    '۵': '5',
                    '۶': '6',
                    '۷': '7',
                    '۸': '8',
                    '۹': '9',
                };
                return text.replace(/[\u06F0-\u06F9]/g, (c) => persianToEnglish[c]);
            }
            const textWithEnglishNumbers = convertToEnglishNumbers(text);

            const textarea = document.createElement('textarea');
            textarea.value = textWithEnglishNumbers;
            document.body.appendChild(textarea);
            textarea.select();

            try {
                document.execCommand('copy');
                toastr.info('کپی شد!', null, { timeOut: 1000 });
            } catch (e) {
                toastr.error('مشکلی در کپی کردن به وجود آمد!', null, { timeOut: 1000 });
            }
            document.body.removeChild(textarea);
        }
        $("#peerLogs").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
@endsection
