@extends('seller.dashboard.main.main')
@section('title',$user->username)

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">خرید کانکشن برای {{$user->username}}</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('seller.dashboard.users.addPeer',$user) }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')

@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">توضیح</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <input type="text" name="description" class="form-control" oninput="changeDescription(this)" placeholder="توضیح جهت شناسایی کانکشن کاربر">
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">کشور</h3>
                </div>
                <div class="card-body">
                    <div class="row" style="gap: 0.5rem">
                        @foreach($locations as $location)
                            <div class="form-group">
                                <button type="button" class="btn btn-block btn-lg location-btn" onclick="locationFilter(this,'{{$location}}')">{{$location}}</button>
                            </div>
                        @endforeach
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">سرور</h3>
                </div>
                <div class="card-body">
                    <div class="row" style="gap: 0.5rem">

                        @foreach($wireguards as $wireguard)
                            @if($wireguard->peerLimit()==false)
                                <div class="form-group">
                                    <button type="button" class="btn btn-block btn-lg server-btn {{'location-'.$wireguard->location}}" onclick="serverSelect(this,{{$wireguard->id}})">{{$wireguard->title}}</button>
                                </div>
                            @endif
                        @endforeach
                        @foreach($wireguards as $wireguard)
                            @if($wireguard->peerLimit()==true)
                                <div class="form-group">
                                    <button type="button" class="disabled btn btn-block btn-lg server-btn {{'location-'.$wireguard->location}}" onclick="toastr.error('ظرفیت تکمیل شده است')">{{$wireguard->title}}</button>
                                </div>
                            @endif
                        @endforeach

                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">پلن</h3>
                </div>
                <div class="card-body">
                    <div class="table-wrapper">
                        <table class="table table-striped">
                            @foreach($peer_plans as $peerPlan)
                                <tr>
                                    <td>{{$peerPlan->title}}</td>
                                    <td>حجم: {{$peerPlan->traffic?(($peerPlan->traffic/1000)." گیگابایت"):"نامحدود"}}</td>
                                    <?php
                                    $durations = [];
                                    if($peerPlan->duration_year != 0){
                                        $durations[] = $peerPlan->duration_year.' سال ';
                                    }
                                    if($peerPlan->duration_month != 0){
                                        $durations[] = $peerPlan->duration_month.' ماه ';
                                    }
                                    if($peerPlan->duration_day != 0){
                                        $durations[] = $peerPlan->duration_day.' روز ';
                                    }
                                    ?>
                                    <td>مدت زمان: {{implode(' و ',$durations)}}</td>
                                    <?php
                                    $seller = auth('seller')->user();
                                    $peer_plan_price = $peerPlan->price;
                                    if($seller->plan && $seller->plan->discount_plan>0){
                                        $peer_plan_price *= (1-($seller->plan->discount_plan??0)/100);
                                    }
                                    ?>
                                    <td>قیمت:
                                        @if($peerPlan->price != $peer_plan_price)
                                            <del>{{number_format($peerPlan->price)}}</del>
                                            {{number_format($peer_plan_price)}}
                                        @else
                                            {{number_format($peerPlan->price)}}
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-block btn-secondary btn--small plan-btn" onclick="planSelect(this,{{$peerPlan->id}})">خرید</button>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
@endsection
@section('end_body')
    <script>
        var wireguard_id = 0;
        var description = '';
        function locationFilter(e,location){
            wireguard_id = 0;
            refreshPlanKeys()
            let locationBtns = document.getElementsByClassName('location-btn');
            for (let i = 0; i < locationBtns.length; i++) {
                locationBtns[i].classList.remove('btn-outline-success');
                locationBtns[i].classList.add('btn-outline-dark');
            }
            e.classList.add('btn-outline-success');
            e.classList.remove('btn-outline-dark');


            let servers = document.getElementsByClassName('server-btn');
            for (let i = 0; i < servers.length; i++) {
                if (servers[i].classList.contains('location-'+location)) {
                    servers[i].parentElement.style.display = 'block';
                }else{
                    servers[i].parentElement.style.display = 'none';
                }
                servers[i].classList.remove('btn-outline-success');
                servers[i].classList.add('btn-outline-dark');
            }
        }
        function serverSelect(e,id){
            let servers = document.getElementsByClassName('server-btn');
            for (let i = 0; i < servers.length; i++) {
                servers[i].classList.remove('btn-outline-success');
                servers[i].classList.add('btn-outline-dark');
            }
            e.classList.add('btn-outline-success');
            e.classList.remove('btn-outline-dark');
            wireguard_id = id;
            refreshPlanKeys()
        }
        function refreshPlanKeys(){
            if(wireguard_id === 0){
                let planBtns = document.getElementsByClassName('plan-btn');
                for (let i = 0; i < planBtns.length; i++) {
                    planBtns[i].disabled = true;
                }
            }else{
                let planBtns = document.getElementsByClassName('plan-btn');
                for (let i = 0; i < planBtns.length; i++) {
                    planBtns[i].disabled = false;
                }
            }
        }
        locationFilter(document.getElementsByClassName('location-btn')[0],'{{$locations[0]}}');
        function planSelect(e,id){
            if(wireguard_id === 0){
                alert('لطفا ابتدا سرور مورد نظر را انتخاب کنید');
                return;
            }

            let form = document.createElement('form');
            form.setAttribute('method','post');
            form.setAttribute('action','{{route('seller.dashboard.users.addPeer',$user)}}');
            let csrf = document.createElement('input');
            csrf.setAttribute('type','hidden');
            csrf.setAttribute('name','_token');
            csrf.setAttribute('value','{{csrf_token()}}');
            let wireguard_id_ch = document.createElement('input');
            wireguard_id_ch.setAttribute('type','hidden');
            wireguard_id_ch.setAttribute('name','wireguard_id');
            wireguard_id_ch.setAttribute('value',wireguard_id);
            let peer_plan_id = document.createElement('input');
            peer_plan_id.setAttribute('type','hidden');
            peer_plan_id.setAttribute('name','peer_plan_id');
            peer_plan_id.setAttribute('value',id);
            let description_ch = document.createElement('input');
            description_ch.setAttribute('type','hidden');
            description_ch.setAttribute('name','description');
            description_ch.setAttribute('value',description);
            form.appendChild(description_ch);
            form.appendChild(wireguard_id_ch);
            form.appendChild(csrf);
            form.appendChild(peer_plan_id);
            document.body.appendChild(form);
            form.submit();

        }
        function changeDescription(e){
            description = e.value;
        }
    </script>
@endsection
