@extends('seller.dashboard.main.main')
@section('title','کانکشن های '.__($status))

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">کانکشن های {{__($status)}}</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('seller.dashboard.peers.listStatus',$status) }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')
    <link rel="stylesheet" href="{{asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')}}">
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">کانکشن ها</h3>
                </div>
                <div class="card-body">
                    <table id="peerListStatus" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>کاربر</th>
                            <th>توضیح</th>
                            <th>شناسه عمومی</th>
                            <th>کشور</th>
                            <th>حجم کل</th>
                            <th>حجم مصرفی</th>
                            <th>زمان پایان</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        function destroyString($string){
                            if (strlen($string) > 6) {
                                $start = substr($string, 0, 7); // extract the first 5 characters
                                $end = substr($string, -7); // extract the last 8 characters

                                $middle = '...'; // placeholder for the middle portion
                                $result = $start . $middle . $end;
                            } else {
                                $result = $string; // if the string is already shorter than the maximum length
                            }
                            return $result;
                        }
                        ?>
                        @foreach($peers as $peer)
                            <tr class="peer-item">
                                <td class="peer-item__title">
                                    {{$peer->id}}
                                </td>
                                <td class="peer-item__user">
                                    <a href="{{route('seller.dashboard.users.show',$peer->user->id)}}">{{$peer->user->username}}</a>
                                </td>
                                <td class="peer-item__title">
                                    {{$peer->description??"نامشخص"}}
                                </td>
                                <td class="peer-item__title wgt-enNumber" style="direction: ltr">
                                    {{destroyString($peer->publicKey())}}
                                </td>
                                <td class="peer-item__country">
                                    {{$peer->wireguard->location}}
                                </td>
                                <td class="peer-item__traffic_restrictions">
                                    {{$peer->traffic_restrictions/1000}} GB
                                </td>
                                <td class="peer-item__traffic_usage_total">
                                    {{$peer->traffic_usage_current() + $peer->traffic_usage_total()}} GB
                                </td>
                                <td class="peer-item__expire_at">
                                    {{jdate($peer->expires_at)}}
                                </td>
                                <td class="peer-item__actions">
                                    <a class="btn btn-outline-secondary btn-sm" href="{{route('seller.dashboard.users.peer.show',$peer->id)}}">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
@endsection
@section('end_body')
    <script src="{{asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')}}"></script>
    <script>
        $("#peerListStatus").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
@endsection
