@extends('seller.dashboard.main.main')
@section('title','تراکنش های معتبر')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">تراکنش های معتبر</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('seller.dashboard.financial.validTransactions') }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')
    <link rel="stylesheet" href="{{asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')}}">
@endsection
@section('content')
    <?php
        function destroyString($string){
            if (strlen($string) > 6) {
                $start = substr($string, 0, 7); // extract the first 5 characters
                $end = substr($string, -7); // extract the last 8 characters

                $middle = '...'; // placeholder for the middle portion
                $result = $start . $middle . $end;
            } else {
                $result = $string; // if the string is already shorter than the maximum length
            }
            return $result;
        }
    ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تراکنش های معتبر</h3>
                </div>
                <div class="card-body">
                    <table id="Transactions" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>نماد</th>
                            <th>TransactionID</th>
                            <th>از</th>
                            <th>به</th>
                            <th>مقدار</th>
                            <th>نرخ ارز</th>
                            <th>زمان ثبت</th>
                            <th>وضعیت</th>
                        </tr>
                        </thead>
                        <tbody>

                        @foreach($transactions as $transaction)
                            <tr>
                                <td>{{$transaction->symbol}}</td>
                                <td class="wgt-enNumber">{{destroyString($transaction->transaction_id)}}</td>
                                <td class="wgt-enNumber">{{destroyString($transaction->from_wallet)??"نامشخص"}}</td>
                                <td class="wgt-enNumber">{{destroyString($transaction->wallet)}}</td>
                                <td>{{(($transaction->amount))}}</td>
                                <td>{{number_format($transaction->IRT_rate)}}</td>
                                <td>{{jdate($transaction->created_at)}}</td>
                                <td>
                                    @if($transaction->status == App\Status\SellerTransaction::NEW)
                                        <span class="badge badge-primary">درحال بررسی</span>
                                    @elseif($transaction->status == App\Status\SellerTransaction::SUCCESS)
                                        <span class="badge badge-success">موفق</span>
                                    @elseif($transaction->status == App\Status\SellerTransaction::FAILED)
                                        <span class="badge badge-danger">ناموفق</span>
                                    @else
                                        <span class="badge badge-warning">نامشخص</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
@endsection
@section('end_body')
    <script src="{{asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')}}"></script>
    <script>
        $("#Transactions").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
@endsection
