@extends('seller.dashboard.main.main')
@section('title',"افزایش موجودی")

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">افزایش موجودی</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('seller.dashboard.financial.increaseWallet') }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')

@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-outline">
                <div class="card-header">
                    <h3 class="card-title">متد پرداخت</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($TransactionWallets as $TransactionWallet)
                            <div class="col-lg-2 form-group">
                                <button type="button" class="btn btn-block btn-lg symbol-btn btn-outline-dark" onclick="selectMethod(this,'{{$TransactionWallet->id}}')">{{$TransactionWallet->name}}</button>
                            </div>
                        @endforeach
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            @foreach($TransactionWallets as $TransactionWallet)
                <div class="card card-outline wallet-details-card" id="wallet-{{$TransactionWallet->id}}" style="display: none">
                    <div class="card-header">
                        <h3 class="card-title">{{$TransactionWallet->name." - ".$TransactionWallet->symbol}}</h3>
                    </div>
                    <div class="card-body">
                        <div class="col-lg-12 form-group">
                            <label>آدرس ولت</label>
                            <div type="text" class="form-control wgt-enNumber" style="text-align: center; background: #ececec" onclick="selectTextInDivAndCopy(this);">{{$TransactionWallet->wallet}}</div>
                        </div>
                        <div class="col-lg-12 form-group">
                            <div class="" style="text-align: center;"><label class="" style="color: crimson">نرخ ارز: {{number_format($TransactionWallet->IRT_rate())." تومان"}}</label></div>
                        </div>
                        <div class="col-lg-12 form-group text-center">
                            <img src="{{asset('contents/seller_transaction_wallets/'.$TransactionWallet->id.".png")."?v=".env('APP_VERSION')}}" class="img-rounded" style="max-height: 700px;max-width: 400px; width: 100%"/>
                        </div>
                        <div class="col-lg-12 form-group text-center">
                            <p>{!! $TransactionWallet->description !!}</p>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            @endforeach
            <div class="card card-outline">
                <div class="card-header">
                    <h3 class="card-title">TransactionID</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <input type="text" name="description" class="form-control" oninput="changeTransactionID(this)" placeholder="ُُTransactionID را به صورت دقیق وارد کنید">
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary" onclick="submitTransaction()">تایید</button>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
@endsection
@section('end_body')
    <script>
        var transactionID = "";
        var walletID = "";
        function selectTextInDivAndCopy(element) {
            function convertToEnglishNumbers(text) {
                const persianToEnglish = {
                    '۰': '0',
                    '۱': '1',
                    '۲': '2',
                    '۳': '3',
                    '۴': '4',
                    '۵': '5',
                    '۶': '6',
                    '۷': '7',
                    '۸': '8',
                    '۹': '9',
                };
                return text.replace(/[\u06F0-\u06F9]/g, (c) => persianToEnglish[c]);
            }
            const range = document.createRange();
            range.selectNodeContents(element);
            const textWithEnglishNumbers = convertToEnglishNumbers(range.toString());
            const tempElement = document.createElement('div');
            tempElement.textContent = textWithEnglishNumbers;
            document.body.appendChild(tempElement);

            const selection = window.getSelection();
            selection.removeAllRanges();
            range.selectNodeContents(tempElement);
            selection.addRange(range);

            try {
                document.execCommand('copy');
                toastr.info('کپی شد!', null, { timeOut: 1000 });
            } catch (e) {
                toastr.error('مشکلی در کپی کردن به وجود آمد!', null, { timeOut: 1000 });
            }
            document.body.removeChild(tempElement);
        }

        function selectMethod(e,id){
            let symbolBtns = document.getElementsByClassName('symbol-btn');
            for (let i = 0; i < symbolBtns.length; i++) {
                symbolBtns[i].classList.remove('btn-outline-success');
                symbolBtns[i].classList.add('btn-outline-dark');
            }
            e.classList.add('btn-outline-success');
            e.classList.remove('btn-outline-dark');
            let walletDetailsCard = document.getElementsByClassName('wallet-details-card');
            for (let i = 0; i < walletDetailsCard.length; i++) {
                walletDetailsCard[i].style.display = "none";
            }
            document.getElementById('wallet-'+id).style.display = "block";
            walletID = id;
        }
        selectMethod(document.getElementsByClassName('symbol-btn')[0],'{{$TransactionWallets[0]->id}}');
        function changeTransactionID(e){
            transactionID = e.value;
        }

        function submitTransaction(){
            if(transactionID === "" || transactionID === null || transactionID === undefined){
                toastr.error("لطفا TransactionID را وارد کنید!");
            }else if(walletID === "" || walletID === null || walletID === undefined){
                toastr.error("لطفا متد پرداخت را انتخاب کنید!");
            }else{
                let form = document.createElement('form');
                form.setAttribute('method','post');
                form.setAttribute('action','{{route('seller.dashboard.financial.increaseWallet')}}');
                let csrf = document.createElement('input');
                csrf.setAttribute('type','hidden');
                csrf.setAttribute('name','_token');
                csrf.setAttribute('value','{{csrf_token()}}');
                let transactionIDInput = document.createElement('input');
                transactionIDInput.setAttribute('type','hidden');
                transactionIDInput.setAttribute('name','transaction_id');
                transactionIDInput.setAttribute('value',transactionID);
                let walletIDInput = document.createElement('input');
                walletIDInput.setAttribute('type','hidden');
                walletIDInput.setAttribute('name','wallet_id');
                walletIDInput.setAttribute('value',walletID);
                form.appendChild(csrf);
                form.appendChild(transactionIDInput);
                form.appendChild(walletIDInput);
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
@endsection
