@extends('admin.dashboard.main.main')
@section('title',$server->title)

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{$server->title??"نامشخص"}}</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('admin.dashboard.servers.show',$server) }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')
    <link rel="stylesheet" href="{{asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />

@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-cyan">
                <div class="card-body">
                    <div class="table-wrapper">
                        <table class="table table-striped">
                            <tr>
                                <td>نام کاربری</td>
                                <td class="wgt-enNumber">{{$server->username}}</td>
                            </tr>
                            <tr>
                                <td>آیپی</td>
                                <td class="wgt-enNumber">{{$server->ipAddress??"نامشخص"}}</td>
                            </tr>
                            <tr>
                                <td>نام کاربری</td>
                                <td class="wgt-enNumber">{{$server->username??"نامشخص"}}</td>
                            </tr>
                            <tr>
                                <td>کلمه عبور</td>
                                <td class="wgt-enNumber">{{$server->password}}</td>
                            </tr>
                            <tr>
                                <td>پورت ورود</td>
                                <td class="wgt-enNumber">{{$server->apiPort}}</td>
                            </tr>

                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-warning" onclick="editServerModal()">ویرایش</button>
                </div>
            </div>

            <div class="card card-cyan">
                <div class="card-header">
                    <h3 class="card-title">اینترفیس های وایرگارد</h3>
                </div>
                <div class="card-body">
                    @foreach($server->wireguards as $wireguard)
                        <div class="text-center">
                            <p class="font-weight-bold" style="font-size: 25px">{{$wireguard->title}}
                                <a class="btn btn-sm" href="#" onclick="editWireguardModal('editInterface_{{$wireguard->id}}')">
                                    <i class="fa fa-edit text-secondary"></i>
                                </a>
                            </p>
                        </div>
                        <div class="table-wrapper">
                            <table class="table table-striped">
                                <tr>
                                    <td>نام اینترفیس</td>
                                    <td class="wgt-enNumber">{{$wireguard->interfaceName}}</td>
                                </tr>
                                <tr style="direction: ltr;">
                                    <td>کلید عمومی</td>
                                    <td class="wgt-enNumber">{{(new \App\Helper\WireGuardHelper())->privateKeyToPublicKey($wireguard->privateKey)}}</td>
                                </tr>
                                <tr>
                                    <td>پورت</td>
                                    <td class="wgt-enNumber">{{$wireguard->listenPort}}</td>
                                </tr>
                                <tr>
                                    <td>DNS</td>
                                    <td class="wgt-enNumber">{{$wireguard->dns}}</td>
                                </tr>
                                <tr>
                                    <td>موقعیت</td>
                                    <td class="wgt-enNumber">{{$wireguard->location}}</td>
                                </tr>
                                <tr>
                                    <td>دامین</td>
                                    <td class="wgt-enNumber">{{$wireguard->domain}}</td>
                                </tr>
                            </table>
                        </div>
                        <div id="editInterface_{{$wireguard->id}}" class="modal">
                            <form method="post" action="{{route('admin.dashboard.servers.editWireguard',['server_id'=>$server->id,'wireguard_id'=>$wireguard->id])}}">
                                @csrf
                                <div class="row">
                                    <div class="col-lg-12 form-group text-right">
                                        <label>عنوان</label>
                                        <input type="text" name="title" class="form-control" value="{{$wireguard->title}}">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>نام اینترفیس</label>
                                        <input type="text" name="interfaceName" class="form-control" value="{{$wireguard->interfaceName}}">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>پورت</label>
                                        <input type="tel" name="listenPort" class="form-control" value="{{$wireguard->listenPort}}">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>DNS</label>
                                        <input type="text" name="dns" class="form-control" value="{{$wireguard->dns}}">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>موقعیت</label>
                                        <input type="text" name="location" class="form-control" value="{{$wireguard->location}}">
                                    </div>
                                    <div class="col-lg-12 form-group text-right">
                                        <label>دامین</label>
                                        <input type="text" name="domain" class="form-control" value="{{$wireguard->domain}}">
                                    </div>
                                    <div class="col-lg-12 form-group">
                                        <button type="submit" class="btn btn-success">ثبت</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div id="editServer" class="modal">
        <form method="post" action="{{route('admin.dashboard.servers.edit',$server->id)}}">
            @csrf
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>عنوان</label>
                    <input type="text" name="title" class="form-control" value="{{$server->title}}">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>ایپی</label>
                    <input type="text" name="ipAddress" class="form-control" value="{{$server->ipAddress}}">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>نام کاربری</label>
                    <input type="text" name="username" class="form-control" value="{{$server->username}}">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>کلمه عبور</label>
                    <input type="text" name="password" class="form-control" value="{{$server->password}}">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>پورت ورود</label>
                    <input type="text" name="apiPort" class="form-control" value="{{$server->apiPort}}">
                </div>
                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('end_body')
    <script src="{{asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script>
        function editServerModal(){
            $('#editServer').modal({
                showClose: false,
            });
        }
        function editWireguardModal(id){
            $('#'+id).modal({
                showClose: false,
            });
        }
    </script>
@endsection
