@extends('admin.dashboard.main.main')
@section('title','کیف پول')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">کیف پول</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('admin.dashboard.sellers.wallet',$seller) }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')
    <link rel="stylesheet" href="{{asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تاریخچه کیف پول</h3>
                    <div class="card-tools">
                        <a href="#addBalance" class="btn btn-success" onclick="addBalanceModal()">+</a>
                        <a href="#reduceBalance" class="btn btn-danger" onclick="reduceBalanceModal()">-</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <p class="font-weight-bold" style="font-size: 25px" >{{number_format($seller->balance)}} تومان</p>
                    </div>
                    <table id="wallet" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>تاریخ</th>
                            <th>نوع</th>
                            <th>مبلغ</th>
                            <th>توضیح</th>
                        </tr>
                        </thead>
                        <tbody>

                        @foreach($seller->transactions->sortByDesc('id') as $transaction)
                            <tr class="number-item">
                                <td class="number-item__date">
                                    <time datetime="{{(jdate($transaction->updated_at))}}">{{(jdate($transaction->updated_at))}}</time>
                                </td>
                                <td class="number-item__type">
                                    <span class="number-item__type--success">{{__($transaction->type)}}</span>
                                </td>
                                <td class="number-item__price">{{(number_format($transaction->amount))}} تومان</td>
                                <td class="number-item__gateway">{{$transaction->meta['description']??""}}</td>

                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
    <div id="reduceBalance" class="modal">
        <form method="post" action="{{route('admin.dashboard.sellers.wallet.reduceBalance',$seller->id)}}">
            @csrf
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>مقدار کاهش موجودی</label>
                    <input type="tel" name="amount" class="form-control" placeholder="تومان">
                </div>

                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-danger">کاهش موجودی</button>
                </div>
            </div>
        </form>
    </div>
    <div id="addBalance" class="modal">
        <form method="post" action="{{route('admin.dashboard.sellers.wallet.addBalance',$seller->id)}}">
            @csrf
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>مقدار افزایش موجودی</label>
                    <input type="tel" name="amount" class="form-control" placeholder="تومان">
                </div>

                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">افزایش موجودی</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('end_body')
    <script src="{{asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script>
        $("#wallet").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
        function addBalanceModal(){
            $('#addBalance').modal({
                showClose: false,
            });
        }
        function reduceBalanceModal(){
            $('#reduceBalance').modal({
                showClose: false,
            });
        }
    </script>
@endsection
