@extends('admin.dashboard.main.main')
@section('title',$seller->username)

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{$seller->username??"نامشخص"}}</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('admin.dashboard.sellers.show',$seller) }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')
    <link rel="stylesheet" href="{{asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />

@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-cyan">
                <div class="card-body">
                    <div class="table-wrapper">
                        <table class="table table-striped">
                            <tr>
                                <td>پلن</td>
                                <td>{{$seller->plan->title??"عمومی"}}</td>
                            </tr>
                            <tr>
                                <td>نام کاربری</td>
                                <td>{{$seller->username}}</td>
                            </tr>
                            <tr>
                                <td>تلفن تماس</td>
                                <td>{{$seller->phone}}</td>
                            </tr>
                            <tr>
                                <td>ایمیل</td>
                                <td>{{$seller->email}}</td>
                            </tr>
                            <tr>
                                <td>تعداد کاربران</td>
                                <td>{{$seller->users->count()}}</td>
                            </tr>
                            <tr>
                                <td>کد معرف</td>
                                <td>{{$seller->referral_code}}</td>
                            </tr>
                            <tr>
                                <td>کیف پول</td>
                                <td>{{number_format($seller->balance)}}
                                    <a class="btn  btn-sm" href="{{route('admin.dashboard.sellers.wallet',$seller->id)}}">
                                        <i class="fa fa-eye text-secondary"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>وضعیت</td>
                                <td>
                                    @if($seller->status == App\Status\Seller::ACTIVE)
                                        <span class="badge badge-success">فعال</span>
                                    @elseif($seller->status == App\Status\Seller::INACTIVE)
                                        <span class="badge badge-danger">غیر فعال</span>
                                    @elseif($seller->status == App\Status\Seller::NEW)
                                        <span class="badge badge-danger">جدید</span>
                                    @else
                                        <span class="badge badge-warning">نامشخص</span>
                                    @endif
                                </td>
                            </tr>
                            @if(session()->has('newPassword'))
                                <tr>
                                    <td style="color: red">رمز عبور جدید</td>
                                    <td>{{session('newPassword')}}</td>
                                </tr>
                            @endif
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <button class="btn btn-warning" onclick="editSellerModal()">ویرایش</button>
                    <button class="btn btn-danger float-left" onclick="window.location.href='{{route('admin.dashboard.sellers.resetPassword',$seller->id)}}'">تغییر کلمه عبور</button>
                    @if($seller->status == App\Status\Seller::ACTIVE)
                        <button class="btn btn-danger float-left" onclick="window.location.href='{{route('admin.dashboard.sellers.changeStatus',['id'=>$seller->id,'status'=>"inactive"])}}'">غیر فعال سازی</button>
                    @elseif($seller->status == App\Status\Seller::INACTIVE)
                        <button class="btn btn-success float-left" onclick="window.location.href='{{route('admin.dashboard.sellers.changeStatus',['id'=>$seller->id,'status'=>"active"])}}'">فعال سازی</button>
                    @elseif($seller->status == App\Status\Seller::NEW)
                        <button class="btn btn-success float-left" onclick="window.location.href='{{route('admin.dashboard.sellers.changeStatus',['id'=>$seller->id,'status'=>"active"])}}'">فعال سازی</button>
                    @endif
                </div>
            </div>
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تاریخچه تغییرات نماینده</h3>
                </div>
                <div class="card-body">
                    <table id="sellerLogs" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>تاریخ</th>
                            <th>توضیح</th>
                        </tr>
                        </thead>
                        <tbody>

                        @foreach($seller->logs->sortByDesc('created_at') as $log)
                            <tr class="peerLog-item">
                                <td class="peerLog-item__date">
                                    <time datetime="{{(jdate($log->created_at))}}">{{(jdate($log->created_at))}}</time>
                                </td>
                                <td class="peerLog-item__log">{{(new \App\Helper\Translate())->string($log->log)}}</td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>

            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">کانکشن ها</h3>
                </div>
                <div class="card-body">
                    <table id="peerListStatus" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>کاربر</th>
                            <th>توضیح</th>
                            <th>شناسه عمومی</th>
                            <th>کشور</th>
                            <th>حجم کل</th>
                            <th>حجم مصرفی</th>
                            <th>زمان پایان</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        function destroyString($string){
                            if (strlen($string) > 6) {
                                $start = substr($string, 0, 7); // extract the first 5 characters
                                $end = substr($string, -7); // extract the last 8 characters

                                $middle = '...'; // placeholder for the middle portion
                                $result = $start . $middle . $end;
                            } else {
                                $result = $string; // if the string is already shorter than the maximum length
                            }
                            return $result;
                        }
                        ?>
                        @foreach($seller->users as $user)
                            @foreach($user->peers as $peer)
                                <tr class="peer-item">
                                    <td class="peer-item__title">
                                        {{$peer->id}}
                                    </td>
                                    <td class="peer-item__user">
                                        {{$peer->user->username}}
                                    </td>
                                    <td class="peer-item__title">
                                        {{$peer->description??"نامشخص"}}
                                    </td>
                                    <td class="peer-item__title wgt-enNumber" style="direction: ltr">
                                        {{destroyString($peer->publicKey())}}
                                    </td>
                                    <td class="peer-item__country">
                                        {{$peer->wireguard->location}}
                                    </td>
                                    <td class="peer-item__traffic_restrictions">
                                        {{$peer->traffic_restrictions/1000}} GB
                                    </td>
                                    <td class="peer-item__traffic_usage_total">
                                        {{$peer->traffic_usage_current() + $peer->traffic_usage_total()}} GB
                                    </td>
                                    <td class="peer-item__expire_at">
                                        {{jdate($peer->expires_at)}}
                                    </td>
                                </tr>
                            @endforeach
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تراکنش های معتبر</h3>
                </div>
                <div class="card-body">
                    <table id="Transactions" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>نماد</th>
                            <th>TransactionID</th>
                            <th>از</th>
                            <th>به</th>
                            <th>مقدار</th>
                            <th>نرخ ارز</th>
                            <th>زمان ثبت</th>
                            <th>وضعیت</th>
                        </tr>
                        </thead>
                        <tbody>

                        @foreach($seller->seller_transactions as $transaction)
                            <tr>
                                <td>{{$transaction->symbol}}</td>
                                <td class="wgt-enNumber">{{($transaction->transaction_id)}}</td>
                                <td class="wgt-enNumber">{{($transaction->from_wallet)??"نامشخص"}}</td>
                                <td class="wgt-enNumber">{{($transaction->wallet)}}</td>
                                <td>{{(($transaction->amount))}}</td>
                                <td>{{number_format($transaction->IRT_rate)}}</td>
                                <td>{{jdate($transaction->created_at)}}</td>
                                <td>
                                    @if($transaction->status == App\Status\SellerTransaction::NEW)
                                        <span class="badge badge-primary">درحال بررسی</span>
                                    @elseif($transaction->status == App\Status\SellerTransaction::SUCCESS)
                                        <span class="badge badge-success">موفق</span>
                                    @elseif($transaction->status == App\Status\SellerTransaction::FAILED)
                                        <span class="badge badge-danger">ناموفق</span>
                                    @else
                                        <span class="badge badge-warning">نامشخص</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
    <div id="editSeller" class="modal">
        <form method="post" action="{{route('admin.dashboard.sellers.edit',$seller->id)}}">
            @csrf
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>نام کاربری</label>
                    <input type="text" name="username" class="form-control" value="{{$seller->username}}">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>تلفن تماس</label>
                    <input type="text" name="phone" class="form-control" value="{{$seller->phone}}">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>ایمیل</label>
                    <input type="text" name="email" class="form-control" value="{{$seller->email}}">
                </div>

                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('end_body')
    <script src="{{asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script>
        function editSellerModal(){
            $('#editSeller').modal({
                showClose: false,
            });
        }
        $("#peerListStatus").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
        $("#sellerLogs").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
        $("#Transactions").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
@endsection
