@extends('admin.dashboard.main.main')
@section('title','لیست پلن های نمایندگان')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">لیست پلن های نمایندگان</h1>
                </div><!-- /.col -->
                {{ Breadcrumbs::render('admin.dashboard.sellers.plans.list') }}
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection
@section('end_head')
    <link rel="stylesheet" href="{{asset('assets/plugins/datatables/jquery.dataTables.css')."?v=".env('APP_VERSION')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">لیست پلن های نمایندگان</h3>
                    <div class="card-tools">
                        <a href="#addPlan" class="btn btn-success" onclick="addPlanModal()">+</a>
                    </div>
                </div>
                <div class="card-body">
                    <table id="sellersTable" class="table table-bordered table-hover display" style="width:100%">
                        <thead>
                        <tr>
                            <th>عنوان</th>
                            <th>موجودی بیشتر به ازای هر افزایش موجودی</th>
                            <th>تخفیف بیشتر خرید پلان</th>
                            <th>حداقل واریز ۳ماهه</th>
                            <th>درصد سود از زیر مجموعه</th>
                            <th>حداکثر تعداد زیر مجموعه</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($plans as $plan)
                            <tr>
                                <td>{{$plan->title}}</td>
                                <td>{{$plan->deposit_bonus}} ٪</td>
                                <td>{{$plan->discount_plan}} ٪</td>
                                <td>{{number_format($plan->min_three_months_deposit)}} تومان</td>
                                <td>{{$plan->referral_percent}} ٪ از شارژ زیر مجموعه</td>
                                <td>{{$plan->max_referral_count}}</td>
                                <td>
                                    <a class="btn btn-outline-secondary btn-sm" href="#" onclick="editPlanModal('editPlan-{{$plan->id}}')">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <a class="btn btn-outline-secondary btn-sm" href="{{route('admin.dashboard.sellers.plans.remove',$plan->id)}}">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                </td>
                            </tr>
                            <div id="editPlan-{{$plan->id}}" class="modal">
                                <form method="post" action="{{route('admin.dashboard.sellers.plans.edit',$plan->id)}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-12 form-group text-right">
                                            <label>عنوان</label>
                                            <input type="text" name="title" class="form-control" value="{{$plan->title}}">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>موجودی بیشتر به ازای هر افزایش موجودی</label>
                                            <input type="tel" name="deposit_bonus" class="form-control" value="{{$plan->deposit_bonus}}">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>تخفیف بیشتر خرید پلان</label>
                                            <input type="tel" name="discount_plan" class="form-control" value="{{$plan->discount_plan}}">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>حداقل واریز ۳ماهه</label>
                                            <input type="tel" name="min_three_months_deposit" class="form-control" value="{{$plan->min_three_months_deposit}}">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>درصد سود از زیر مجموعه</label>
                                            <input type="tel" name="referral_percent" class="form-control" value="{{$plan->referral_percent}}">
                                        </div>
                                        <div class="col-lg-12 form-group text-right">
                                            <label>حداکثر تعداد زیر مجموعه</label>
                                            <input type="tel" name="max_referral_count" class="form-control" value="{{$plan->max_referral_count}}">
                                        </div>

                                        <div class="col-lg-12 form-group">
                                            <button type="submit" class="btn btn-success">ثبت</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @endforeach

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>عنوان</th>
                            <th>موجودی بیشتر به ازای هر افزایش موجودی</th>
                            <th>تخفیف بیشتر خرید پلان</th>
                            <th>حداقل واریز ۳ماهه</th>
                            <th>درصد سود از زیر مجموعه</th>
                            <th>حداکثر تعداد زیر مجموعه</th>
                            <th>عملیات</th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
    </div>
    <div id="addPlan" class="modal">
        <form method="post" action="{{route('admin.dashboard.sellers.plans.add')}}">
            @csrf
            <div class="row">
                <div class="col-lg-12 form-group text-right">
                    <label>عنوان</label>
                    <input type="text" name="title" class="form-control" placeholder="عنوان">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>موجودی بیشتر به ازای هر افزایش موجودی</label>
                    <input type="tel" name="deposit_bonus" class="form-control" value="0">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>تخفیف بیشتر خرید پلان</label>
                    <input type="tel" name="discount_plan" class="form-control" value="0">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>حداقل واریز ۳ماهه</label>
                    <input type="tel" name="min_three_months_deposit" class="form-control" value="0">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>درصد سود از زیر مجموعه</label>
                    <input type="tel" name="referral_percent" class="form-control" value="0">
                </div>
                <div class="col-lg-12 form-group text-right">
                    <label>حداکثر تعداد زیر مجموعه</label>
                    <input type="tel" name="max_referral_count" class="form-control" value="0">
                </div>

                <div class="col-lg-12 form-group">
                    <button type="submit" class="btn btn-success">ثبت</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('end_body')
    <script src="{{asset('assets/plugins/datatables/jquery.dataTables.js')."?v=".env('APP_VERSION')}}"></script>
    <script>
        $("#sellersTable").DataTable({
            ordering: false,
            searching: true,
            paging: true,
            info: false,
            responsive: false,
            dom: '<"top"<f>>rt<"bottom"lp><"clear">',
            // dom: '<"top"<<"title">i><f>>rt<"bottom"pl>'
            language: {
                lengthMenu: "نمایش _MENU_ در هر صفحه",
                thousands: "٬",
                paginate: {
                    first: "اولین",
                    last: "آخرین",
                    next: "بعدی",
                    previous: "قبلی",
                },
                zeroRecords: "موردی یافت نشد",
                info: "مشاهده صفحه _PAGE_ از _PAGES_",
                infoEmpty: "رکوردی موجود نیست",
                infoFiltered: "(فیلتر شده از مجموع _MAX_ مورد)",
                search: "جستجو",
            },
            "fnInitComplete": function() {
                var searchInput = $('div.dataTables_filter input');
                console.log(searchInput);
                searchInput.addClass('form-control');
            }
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
    <script>
        function addPlanModal(){
            $('#addPlan').modal({
                showClose: false,
            });
        }
        function editPlanModal(id){
            $('#'+id).modal({
                showClose: false,
            });
        }
    </script>
@endsection
