<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title')</title>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{asset('/assets/images/favicon.png')."?v=".env('APP_VERSION')}}" type="image/png">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{asset('assets/dist/css/adminlte.css')."?v=".env('APP_VERSION')}}">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

    <!-- bootstrap rtl -->
    <link rel="stylesheet" href="{{asset('assets/dist/css/bootstrap-rtl.min.css')."?v=".env('APP_VERSION')}}">
    <!-- template rtl version -->
    <link rel="stylesheet" href="{{asset('assets/dist/css/custom-style.css')."?v=".env('APP_VERSION')}}">
    <link rel="stylesheet" href="{{asset('assets/dist/css/wg-style.css')."?v=".env('APP_VERSION')}}">
    <link rel="stylesheet" href="{{asset("assets/plugins/toastr/toastr.min.css")."?v=".env('APP_VERSION')}}">
    <script src="{{asset('assets/plugins/tippy/popper.min.js')."?v=".env('APP_VERSION')}}"></script>
    <script src="{{asset('assets/plugins/tippy/tippy-bundle.umd.min.js')."?v=".env('APP_VERSION')}}"></script>
    <script src="{{asset('assets/plugins/intro/intro.js')."?v=".env('APP_VERSION')}}"></script>
    <link rel="stylesheet" href="{{asset("assets/plugins/intro/introjs.css")."?v=".env('APP_VERSION')}}">
    <link rel="stylesheet" href="{{asset("assets/plugins/intro/introjs-rtl.css")."?v=".env('APP_VERSION')}}">

    @yield('end_head')
    @include('googletagmanager::head')
</head>
<body class="hold-transition sidebar-mini layout-fixed wgt">
@include('googletagmanager::body')
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <!-- Left navbar links -->
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#"><i class="fa fa-bars"></i></a>
            </li>
        </ul>
    </nav>
    <!-- /.navbar -->
    <!-- Main Sidebar Container -->
    @include('admin.dashboard.main.left-sidebar')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        @yield('content-header')
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                @yield('content')
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <footer class="main-footer d-flex justify-content-between">
        <p style="margin-bottom: 0 !important;">قدرت گرفته با <a style="color: red">♡</a> توسط تیم موزیلاگیت</p>
        <p class="mr-auto wgt-enNumber" style="margin-bottom: 0 !important;">v.{{env('APP_VERSION')}}</p>
    </footer>

    <!-- Control Sidebar -->
{{--    <aside class="control-sidebar control-sidebar-dark">--}}
{{--        <!-- Control sidebar content goes here -->--}}
{{--    </aside>--}}
    <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="{{asset('assets/plugins/jquery/jquery.min.js')."?v=".env('APP_VERSION')}}"></script>
<!-- Bootstrap 4 -->
<script src="{{asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js')."?v=".env('APP_VERSION')}}"></script>
<!-- FastClick -->
<script src="{{asset('assets/plugins/fastclick/fastclick.js')."?v=".env('APP_VERSION')}}"></script>
<!-- AdminLTE App -->
<script src="{{asset('assets/dist/js/adminlte.min.js')."?v=".env('APP_VERSION')}}"></script>
<!-- AdminLTE for demo purposes -->
<script src="{{asset('assets/dist/js/demo.js')."?v=".env('APP_VERSION')}}"></script>

<script src="{{asset('assets/dist/js/demo.js')."?v=".env('APP_VERSION')}}"></script>
<!--  Toastr  -->
<script src="{{asset("assets/plugins/toastr/toastr.min.js")."?v=".env('APP_VERSION')}}"></script>
@if(session('toastr_success'))
    <script>
        toastr.success('{{session('toastr_success')}}');
    </script>
@endif
@if(session('toastr_info'))
    <script>
        toastr.info('{{session('toastr_info')}}');
    </script>
@endif
@if(session('toastr_warning'))
    <script>
        toastr.warning('{{session('toastr_warning')}}');
    </script>
@endif
@if(session('toastr_error'))
    <script>
        toastr.error('{{session('toastr_error')}}');
    </script>
@endif
<script>
    function enableLoadingBtn(btn){
        btn.disabled = true
    }
    function disableLoadingBtn(btn){
        btn.disabled = false
    }
    function submitForm(form){
        return $.ajax({
            url: form.action,
            type: form.method,
            data: new FormData(form),
            processData: false,
            contentType: false,
        });
    }
</script>
@yield('end_body')
</body>
</html>
