<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ppp_secret_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('ppp_secret_id');
            $table->text('log')->nullable();
            $table->timestamps();
            $table->foreign('ppp_secret_id')->references('id')->on('ppp_secrets')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ppp_secret_logs');
    }
};
