<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ppp_secrets', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('peer_id')->nullable();
            $table->unsignedBigInteger('ppp_profile_id')->nullable();
            $table->unsignedBigInteger('ppp_secret_plan_id')->nullable();
            $table->unsignedBigInteger('extension_ppp_secret_plan_id')->nullable();
            $table->string('username');
            $table->string('password');
            $table->string('type');
            $table->float('traffic_restrictions')->default(0);
            $table->dateTimeTz('expires_at')->nullable();
            $table->float('rx_traffic_usage_total')->default(0);
            $table->float('tx_traffic_usage_total')->default(0);
            $table->float('rx_traffic_usage_current')->default(0);
            $table->float('tx_traffic_usage_current')->default(0);
            $table->string('unique_id')->unique()->nullable();
            $table->boolean('auto_extension')->default(false);
            $table->string('status')->default(App\Status\PppSecret::ACTIVE);
            $table->string('description')->nullable();
            $table->timestamps();

            //key
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('peer_id')->references('id')->on('peers')->onDelete('cascade');
            $table->foreign('ppp_profile_id')->references('id')->on('ppp_profiles')->onDelete('SET NULL');
            $table->foreign('ppp_secret_plan_id')->references('id')->on('ppp_secret_plans')->onDelete('SET NULL');
            $table->foreign('extension_ppp_secret_plan_id')->references('id')->on('ppp_secret_plans')->onDelete('SET NULL');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ppp_secrets');
    }
};
