<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ppp_secret_plans', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('seller_plan_id')->nullable();
            $table->string('title')->default("peer Plan");
            $table->integer('traffic')->default(1000);
            $table->integer('duration_year')->default(0);
            $table->integer('duration_month')->default(0);
            $table->integer('duration_day')->default(0);
            $table->string('price')->default(0);
            $table->string('type')->default(App\Status\PppSecretType::PPTP);
            $table->string('status')->default(App\Status\PppSecretPlan::ACTIVE);
            $table->timestamps();

            //key
            $table->foreign('seller_plan_id')->references('id')->on('seller_plans')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ppp_secret_plans');
    }
};
