<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /*+*
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ppp_profiles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('server_id')->nullable();
            $table->string('title')->default('Profile');
            $table->text('description')->nullable();
            $table->string('name')->default('wg_profile')->comment('profile name in server');
            $table->string('dns')->nullable()->default('9.9.9.9');
            $table->string('location')->nullable();
            $table->string('domain')->nullable();
            $table->string('pool_name')->default("ppp_wg_pool");
            $table->string('ipAddressList')->nullable();
            $table->string('l2tp_ipsec')->nullable();
            $table->boolean('only_one')->default(false);
            $table->string('status')->default(App\Status\PppProfile::ACTIVE);
            $table->timestamps();

            //key
            $table->foreign('server_id')->references('id')->on('servers')->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ppp_profiles');
    }
};
