<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seller_transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('seller_id')->nullable();
            $table->unsignedBigInteger('transaction_wallet_id')->nullable();
            $table->string('symbol');
            $table->string('wallet');
            $table->string('from_wallet')->nullable();
            $table->string('transaction_id')->unique();
            $table->float('amount')->default(0.00);
            $table->integer('IRT_rate')->default(0);
            $table->string('status')->default(App\Status\SellerTransaction::NEW);
            $table->timestamps();
            $table->foreign('seller_id')->references('id')->on('sellers')->onDelete('SET NULL');
            $table->foreign('transaction_wallet_id')->references('id')->on('seller_transaction_wallets')->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seller_transactions');
    }
};
