<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('peer_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('peer_id');
            $table->text('log')->nullable();
            $table->timestamps();
            $table->foreign('peer_id')->references('id')->on('peers')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('peer_logs');
    }
};
