<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('peers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('wireguard_id')->nullable();
            $table->unsignedBigInteger('peer_plan_id')->nullable();
            $table->unsignedBigInteger('extension_peer_plan_id')->nullable();
            $table->string('privateKey')->nullable();
            $table->integer('allowedAddress')->default(1);
            $table->float('traffic_restrictions')->default(0);
            $table->dateTimeTz('expires_at')->nullable();
            $table->float('rx_traffic_usage_total')->default(0);
            $table->float('tx_traffic_usage_total')->default(0);
            $table->float('rx_traffic_usage_current')->default(0);
            $table->float('tx_traffic_usage_current')->default(0);
            $table->string('unique_id')->unique()->nullable();
            $table->boolean('auto_extension')->default(false);
            $table->string('status')->default(App\Status\Peer::ACTIVE);
            $table->string('description')->nullable();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('wireguard_id')->references('id')->on('wireguards')->onDelete('SET NULL');
            $table->foreign('peer_plan_id')->references('id')->on('peer_plans')->onDelete('SET NULL');
            $table->foreign('extension_peer_plan_id')->references('id')->on('peer_plans')->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('peers');
    }
};
