<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wireguards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('server_id')->nullable();
            $table->string('title')->default('WireGuard');
            $table->text('description')->nullable();
            $table->string('interfaceName')->default('wireguard1')->comment('WireGuard name in server');
            $table->string('privateKey')->nullable();
            $table->integer('listenPort')->default(13231);
            $table->string('dns')->nullable()->default('9.9.9.9');
            $table->string('location')->nullable();
            $table->string('domain')->nullable();
            $table->string('ipAddressList')->nullable();
            $table->integer('max_peer')->default(0);
            $table->string('status')->default(App\Status\Wireguard::ACTIVE);
            $table->timestamps();

            $table->foreign('server_id')->references('id')->on('servers')->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wireguards');
    }
};
