<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sellers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('admin_id');
            $table->unsignedBigInteger('plan_id')->nullable();
            $table->unsignedBigInteger('referral_id')->nullable();
            $table->string('username')->unique();
            $table->string('phone')->unique();
            $table->string('email')->unique();
            $table->string('password');
            $table->string('referral_code')->unique();//strtoupper(str::random(6))
            $table->string('status')->default(App\Status\Seller::ACTIVE);
            $table->rememberToken();
            $table->timestamps();

            //foreign keys
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('cascade');
            $table->foreign('plan_id')->references('id')->on('seller_plans')->onDelete('SET NULL');
            $table->foreign('referral_id')->references('id')->on('sellers')->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sellers');
    }
};
