<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seller_plans', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('admin_id');
            $table->string('title')->default("Seller Plan");
            $table->float('deposit_bonus')->default(0.00);
            $table->float('discount_plan')->default(0.00);
            $table->bigInteger('min_three_months_deposit')->default(0);
            $table->float('referral_percent')->default(0.00);
            $table->bigInteger('max_referral_count')->default(0);

            $table->timestamps();

            //foreign keys
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seller_plans');
    }
};
