<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('servers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('admin_id');
            $table->string('title')->nullable();
            $table->string('ipAddress');
            $table->string('username')->default('admin');
            $table->string('password')->nullable();
            $table->integer('apiPort')->default(8728);
            $table->float('rx_traffic_usage_total')->default(0);
            $table->float('tx_traffic_usage_total')->default(0);
            $table->float('rx_traffic_usage_current')->default(0);
            $table->float('tx_traffic_usage_current')->default(0);
            $table->string('status')->default(App\Status\Seller::ACTIVE);
            $table->timestamps();

            //foreign keys
            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('servers');
    }
};
