<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SellerPlan extends Model
{
    use HasFactory;
    protected $fillable = [
        'admin_id',
        'title',
        'deposit_bonus',
        'discount_plan',
        'min_three_months_deposit',
        'referral_percent',
        'max_referral_count',
    ];
    public function peers(){
        return $this->hasMany(PeerPlan::class,'seller_plan_id','id');
    }
}
