<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Bavix\Wallet\Traits\HasWallet;
use Bavix\Wallet\Interfaces\Wallet;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Seller extends Authenticatable implements Wallet
{
    use HasFactory;
    use HasWallet;
    protected $fillable = [
        'admin_id',
        'plan_id',
        'username',
        'phone',
        'email',
        'password',
        'status',
        'referral_id',
        'referral_code'
    ];
    protected $hidden = [
        'password',
    ];
    public function log($log){
        SellerLog::create([
            'seller_id' => $this->id,
            'log' => $log
        ]);
    }
    public function seller_transactions(){
        return $this->hasMany(SellerTransaction::class);
    }
    public function logs(){
        return $this->hasMany(SellerLog::class);
    }
    public function users(){
        return $this->hasMany(User::class);
    }
    public function plan(){
        return $this->belongsTo(SellerPlan::class);
    }
    public function peersCount(){
        $users = $this->users;
        $count = 0;
        foreach ($users as $user){
            $count += $user->peers->count();
        }
        return $count;
    }
    public function sellerTransactions(){
        return $this->hasMany(SellerTransaction::class);
    }
    public function SellerTransactionWallets(){
        $admin = $this->admin;
        return $admin->SellerTransactionWallets;
    }
    public function monthlyDeposit(){
        $transactions = $this->transactions->where('created_at','>',now()->subMonth());
        $deposit = 0;
        foreach ($transactions as $transaction){
            if ($transaction->type == "deposit")
                $deposit += $transaction->amount;
        }
        return $deposit;
    }
    public function ThreeMonthsDeposit(){
        $transactions = $this->transactions->where('created_at','>',now()->subMonths(3));
        $deposit = 0;
        $descriptions = [
            "افزایش موجودی توسط مدیریت",
            "شارژ حساب به دلیل تراکنش شما با شماره تراکنش",
        ];
        foreach ($transactions as $transaction){
            if ($transaction->type == "deposit"){
                foreach ($descriptions as $description){
                    if(str_contains(($transaction->meta['description'])??"",$description)){
                        $deposit += $transaction->amount;
                        break;
                    }
                }
            }
        }
        return $deposit;
    }
    public function nextPlan(){
        $plans = SellerPlan::where('min_three_months_deposit','>=',$this->ThreeMonthsDeposit())->where('id','!=',$this->plan_id)->orderBy('min_three_months_deposit','asc')->get();
        if (count($plans) == 0)
            return null;
        return $plans[0];
    }
    public function admin(){
        return $this->belongsTo(Admin::class);
    }

    public function referral(){
        return $this->belongsTo(Seller::class,'referral_id','id');
    }

    public function subset(){
        return $this->hasMany(Seller::class,'referral_id','id');
    }
    public function changeStatus($status){
        if (defined('\App\Status\Seller::'.$status)){
            $SellerStatus = constant("\App\Status\Seller::" . $status);
            $this->status = $SellerStatus;
            $this->save();
            $this->log("Status Changed to: ".$SellerStatus);
        }else{
            $this->log("Status did not change to ".$status." because it is not a valid status");
        }
    }
}
