<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PppProfile extends Model
{
    use HasFactory;
    protected $fillable = [
        'server_id',
        'title',
        'description',
        'name',
        'dns',
        'location',
        'domain',
        'pool_name',
        'ipAddressList',
        'l2tp_ipsec',
        'only_one',
        'status'
    ];

    public function PppSecrets(){
        return $this->hasMany(PppSecret::class);
    }
    public function server(){
        return $this->belongsTo(Server::class);
    }

}
