<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Admin extends Authenticatable
{
    use HasFactory;
    protected $fillable = [
        'username',
        'phone',
        'password',
        'status'
    ];

    public function SellerTransactionWallets(){
        return $this->hasMany(SellerTransactionWallet::class);
    }
    public function servers(){
        return $this->hasMany(Server::class);
    }
    public function sellers(){
        return $this->hasMany(Seller::class);
    }
    public function seller_plan(){
        return $this->hasMany(SellerPlan::class);
    }
    public function wireguards(){
        return $this->hasMany(Wireguard::class);
    }
    public function seller_plans(){
        return $this->hasMany(SellerPlan::class);
    }
}
