<?php

namespace App\Http\Middleware\user\api;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use function abort;
use function response;

class sharePeerWhitelistIP
{
    public $WhitelistIpAddress =
        [
            '164.132.71.106',
            '185.183.32.137'
        ];
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!in_array($this->getRequestIp(), $this->WhitelistIpAddress)) {
            //json
            if ($request->expectsJson()){
                return response()->json(['message' => 'شما اجازه دسترسی به این بخش را ندارید'], 403);
            }else{
                abort(403, "شما اجازه دسترسی به این بخش را ندارید. ایپی شما: ".$this->getRequestIp());
            }
        }
        return $next($request);
    }
    function getRequestIp(){
        try {
            if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                return $_SERVER['HTTP_CLIENT_IP'];
            }
            else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                return $_SERVER['HTTP_X_FORWARDED_FOR'];
            }
            else {
                return $_SERVER['REMOTE_ADDR'];
            }
        }catch (\Exception $e){
            return false;
        }
    }
}
