<?php

namespace App\Http\Middleware\seller;

use App\Status\Seller;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!in_array(auth('seller')->user()->status, [Seller::ACTIVE])){
            auth('seller')->logout();
            return redirect()->route('seller.auth.login')->with(['toastr_error' => 'وضعیت حساب شما مجاز نیست']);
        }
        return $next($request);
    }
}
