<?php

namespace App\Http\Middleware\admin;

use App\Status\Admin;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!in_array(auth('admin')->user()->status, [Admin::ACTIVE])){
            auth('admin')->logout();
            return redirect()->route('admin.auth.login')->with(['toastr_error' => 'وضعیت حساب شما مجاز نیست']);
        }
        return $next($request);
    }
}
