<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    protected function redirectTo(Request $request): ?string
    {
        if (! $request->expectsJson()) {
            if ($request->routeIs('seller.*')) {
                return route('seller.auth.login');
            }else if ($request->routeIs('admin.*')) {
                return route('admin.auth.login');
            }
        }
        return $request->expectsJson() ? null : route('seller.auth.login');
    }
}
