<?php

namespace App\Http\Controllers\user\api;

use App\Http\Controllers\Controller;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class sharePeerController extends Controller
{
    public function getPeer($unique_id){
        $peer = \App\Models\Peer::where('unique_id',$unique_id)->first();
        if ($peer && $unique_id!=''){
            $sendPeer = [
                'QrBase64' => base64_encode(QrCode::size(300)->margin(3)->format('png')->generate($peer->getConfigText())),
                'ConfigText' => $peer->getConfigText(),
                'status' => $peer->status,
                'fileName'=>'alpha-'.$peer->user->id.$peer->id,
                'usageTraffic'=>$peer->traffic_usage_total() + $peer->traffic_usage_current(),
                'traffic_restrictions'=>$peer->traffic_restrictions,
                'expires_at'=>$peer->expires_at,
            ];
            return response()->json(['status' => 'success','peer'=>$sendPeer]);
        }else{
            return response()->json(['status'=>'error','message' => 'peer not found']);
        }
    }
}
