<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();
        $schedule->command('WireGuard:CheckPeer')->everyTwoMinutes();
        $schedule->command('Financial:CheckSellerTransactionID')->everyThreeMinutes();
        $schedule->command('Seller:PlanManager')->everyFiveMinutes();
        $schedule->command('Seller:AutoDeleteUser')->everyMinute();
        $schedule->command('PPP:CheckConnection')->everyTwoMinutes();
        $schedule->command('PPP:CheckSecret')->everyTwoMinutes();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
