<?php

namespace App\Console\Commands\Seller;

use Illuminate\Console\Command;

class AutoDeleteUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Seller:AutoDeleteUser';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $sellers = \App\Models\Seller::all();
        foreach ($sellers as $seller){
            $users = $seller->users;
            foreach ($users as $user){
                if(!$user->last_activity()){
                    $user->delete();
                }else{
                    if($user->peers->count() == 0){
                        if(now()->diffInDays($user->last_activity()) > 5){
                            $user->delete();
                        }
                    }
                }
            }
        }
    }
}
